package tzi.UserInput.Serial;

import javax.comm.*;

/**
 *   A SerialPortConfiguration object implements all attributes which describe
 *   the serial port configuration.
 *   Additional it gives different methods to change the attributes.
 */
class SerialPortConfiguration {

  private String  mPort              = "COM1";
  private int     mTimeOut           = 5000;
  private int     mBps               = 9600;
  private int     mDataBits          = SerialPort.DATABITS_8;
  private int     mStopBits          = SerialPort.STOPBITS_1;
  private int     mParity            = SerialPort.PARITY_NONE;

  /**
 *      Creates an object with standard port attributes.
   */
  public SerialPortConfiguration() {
  }

  /**
 *      Creates an object with specialized port attributes given by parameters.
   */
  public SerialPortConfiguration(String port, int timeout, int bps, int databits, int stopbits, int parity) {
    setPort(port);
    setTimeOut(timeout);
    setBps(bps);
    setDataBits(databits);
    setStopBits(stopbits);
    setParity(parity);
  }


  public boolean setPort(String param1)  { mPort = param1; return true; }
  public boolean setTimeOut(int param1)  { mTimeOut = param1; return true; }
  public boolean setBps(int param1)      { mBps = param1; return true; }
  public boolean setDataBits(int param1) { mDataBits = param1; return true; }
  public boolean setStopBits(int param1) { mStopBits = param1; return true; }
  public boolean setParity(int param1)   { mParity = param1; return true; }

  public String  getPort()     { return mPort; }
  public int     getTimeOut()  { return mTimeOut; }
  public int     getBps()      { return mBps; }
  public int     getDataBits() { return mDataBits; }
  public int     getStopBits() { return mStopBits; }
  public int     getParity()   { return mParity; }

  public String toString() {
    String retString = "";

    retString += getPort() + ": TimeOut: " + getTimeOut() + ", Bps: " + getBps() + ", DataBits: ";

    if (getDataBits() == SerialPort.DATABITS_5) retString += "5";
    if (getDataBits() == SerialPort.DATABITS_6) retString += "6";
    if (getDataBits() == SerialPort.DATABITS_7) retString += "7";
    if (getDataBits() == SerialPort.DATABITS_8) retString += "8";

    retString += ", StopBits: ";

    if (getStopBits() == SerialPort.STOPBITS_1) retString += "1";
    if (getStopBits() == SerialPort.STOPBITS_1_5) retString += "1,5";
    if (getStopBits() == SerialPort.STOPBITS_2) retString += "2";

    retString += ", Parity: ";

    if (getParity() == SerialPort.PARITY_NONE) retString += "NONE";
    if (getParity() == SerialPort.PARITY_ODD) retString += "ODD";
    if (getParity() == SerialPort.PARITY_EVEN) retString += "EVEN";
    if (getParity() == SerialPort.PARITY_MARK) retString += "MARK";
    if (getParity() == SerialPort.PARITY_SPACE) retString += "SPACE";

    return retString;
  }

}





