package tzi.UserInput.Serial;

import javax.comm.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 *   A SerialPortConfiguration object offers the possibility to configure
 *   the serial port with a GUI dialog. The settings will become available
 *   if the configuration windows is closed.
 */
public class SerialPortConfigurationGUI extends JFrame implements  Runnable, WindowListener {

  public int WIDTH = 480;
  public int HEIGHT = 46;
  public static String TITLE = "SerialPortConfigurationGUI";
  public boolean mFinished;

  Container frameContainer;

//  JTextField textField = new JTextField(50);
  JMenuBar menuBar = new JMenuBar();

  JMenu portMenu = new JMenu("Port");
  ButtonGroup portButtonGroup = new ButtonGroup();
  JRadioButtonMenuItem portCOM1 = new JRadioButtonMenuItem("COM1");
  JRadioButtonMenuItem portCOM2 = new JRadioButtonMenuItem("COM2");
  JRadioButtonMenuItem portCOM3 = new JRadioButtonMenuItem("COM3");
  JRadioButtonMenuItem portCOM4 = new JRadioButtonMenuItem("COM4");

  JMenu timeoutMenu = new JMenu("TimeOut");
  ButtonGroup timeoutButtonGroup = new ButtonGroup();
  JRadioButtonMenuItem timeout01 = new JRadioButtonMenuItem("01 Sekunden");
  JRadioButtonMenuItem timeout05 = new JRadioButtonMenuItem("05 Sekunden");
  JRadioButtonMenuItem timeout10 = new JRadioButtonMenuItem("10 Sekunden");
  JRadioButtonMenuItem timeout15 = new JRadioButtonMenuItem("15 Sekunden");
  JRadioButtonMenuItem timeout30 = new JRadioButtonMenuItem("30 Sekunden");

  JMenu bpsMenu = new JMenu("Bps");
  ButtonGroup bpsButtonGroup = new ButtonGroup();
  JRadioButtonMenuItem bps2400  = new JRadioButtonMenuItem("2400 bps");
  JRadioButtonMenuItem bps4800  = new JRadioButtonMenuItem("4800 bps");
  JRadioButtonMenuItem bps9600  = new JRadioButtonMenuItem("9600 bps");
  JRadioButtonMenuItem bps19200 = new JRadioButtonMenuItem("19200 bps");

  JMenu databitsMenu = new JMenu("DataBits");
  ButtonGroup databitsButtonGroup = new ButtonGroup();
  JRadioButtonMenuItem databits5 = new JRadioButtonMenuItem("5 DataBits");
  JRadioButtonMenuItem databits6 = new JRadioButtonMenuItem("6 DataBits");
  JRadioButtonMenuItem databits7 = new JRadioButtonMenuItem("7 DataBits");
  JRadioButtonMenuItem databits8 = new JRadioButtonMenuItem("8 DataBits");

  JMenu stopbitsMenu = new JMenu("StopBits");
  ButtonGroup stopbitsButtonGroup = new ButtonGroup();
  JRadioButtonMenuItem stopbits1 = new JRadioButtonMenuItem("  1 StopBits");
  JRadioButtonMenuItem stopbits15 = new JRadioButtonMenuItem("1,5 StopBits");
  JRadioButtonMenuItem stopbits2 = new JRadioButtonMenuItem("  2 StopBits");

  JMenu parityMenu = new JMenu("Parity");
  ButtonGroup parityButtonGroup = new ButtonGroup();
  JRadioButtonMenuItem parityNONE = new JRadioButtonMenuItem("NONE");
  JRadioButtonMenuItem parityODD = new JRadioButtonMenuItem("ODD");
  JRadioButtonMenuItem parityEVEN = new JRadioButtonMenuItem("EVEN");
  JRadioButtonMenuItem parityMARK = new JRadioButtonMenuItem("MARK");
  JRadioButtonMenuItem paritySPACE = new JRadioButtonMenuItem("SPACE");

  //////////////////////////////////////////////////////////////////////////////////////////
  public void windowOpened (WindowEvent e) {  }
  public void windowIconified (WindowEvent e) {  }
  public void windowDeiconified (WindowEvent e) {  }
  public void windowActivated (WindowEvent e) {  }
  public void windowDeactivated (WindowEvent e) {  }
  public void windowClosing (WindowEvent e) { this.mFinished = true; }
  public void windowClosed (WindowEvent e) {  }

  //////////////////////////////////////////////////////////////////////////////////////////
  /**
 *      Creates the object but doesn't start the GUI.
   */
  public SerialPortConfigurationGUI() {
    super(TITLE);
    buildGUI();
    setupEventHandlers();
    setSize(WIDTH, HEIGHT);
  }

  //////////////////////////////////////////////////////////////////////////////////////////
  public void run() {
    // Es sollte nie ein neuer Prozess erzeugt werden.
  }


  //////////////////////////////////////////////////////////////////////////////////////////
  /**
 *      Start the configuration GUI, waits for finished configuration process and
 *      updates the attributes of the object given by parameter.
   */
  public SerialPortConfiguration startGUI(SerialPortConfiguration portConfig) {

    portConfig = portConfig;

    if (portConfig.getPort() == "COM1") portCOM1.setSelected(true);
    if (portConfig.getPort() == "COM2") portCOM2.setSelected(true);
    if (portConfig.getPort() == "COM3") portCOM3.setSelected(true);
    if (portConfig.getPort() == "COM4") portCOM4.setSelected(true);

    switch(portConfig.getTimeOut()) {
        case  1000 : timeout01.setSelected(true); break;
        case  5000 : timeout05.setSelected(true); break;
        case 10000 : timeout10.setSelected(true); break;
        case 15000 : timeout15.setSelected(true); break;
        case 30000 : timeout30.setSelected(true); break;
    }

    switch(portConfig.getBps()) {
        case  2400 :  bps2400.setSelected(true); break;
        case  4800 :  bps4800.setSelected(true); break;
        case  9600 :  bps9600.setSelected(true); break;
        case 19200 : bps19200.setSelected(true); break;
    }

    switch(portConfig.getDataBits()) {
        case  SerialPort.DATABITS_5 :  databits5.setSelected(true); break;
        case  SerialPort.DATABITS_6 :  databits6.setSelected(true); break;
        case  SerialPort.DATABITS_7 :  databits7.setSelected(true); break;
        case  SerialPort.DATABITS_8 :  databits8.setSelected(true); break;
    }

    switch(portConfig.getStopBits()) {
        case  SerialPort.STOPBITS_1 :  stopbits1.setSelected(true); break;
        case  SerialPort.STOPBITS_1_5 :  stopbits15.setSelected(true); break;
        case  SerialPort.STOPBITS_2 :  stopbits2.setSelected(true); break;
    }

    switch(portConfig.getParity()) {
        case  SerialPort.PARITY_NONE : parityNONE.setSelected(true); break;
        case  SerialPort.PARITY_ODD : parityODD.setSelected(true); break;
        case  SerialPort.PARITY_EVEN : parityEVEN.setSelected(true); break;
        case  SerialPort.PARITY_MARK : parityMARK.setSelected(true); break;
        case  SerialPort.PARITY_SPACE : paritySPACE.setSelected(true); break;
    }

    mFinished = false;
    show();

    while(!mFinished){
      try{
        Thread.sleep(1);
      } catch(InterruptedException e) {}
    }

    if (portCOM1.isSelected()) portConfig.setPort("COM1");
    if (portCOM2.isSelected()) portConfig.setPort("COM2");
    if (portCOM3.isSelected()) portConfig.setPort("COM3");
    if (portCOM4.isSelected()) portConfig.setPort("COM4");

    if (timeout01.isSelected()) portConfig.setTimeOut(1000);
    if (timeout05.isSelected()) portConfig.setTimeOut(5000);
    if (timeout10.isSelected()) portConfig.setTimeOut(10000);
    if (timeout15.isSelected()) portConfig.setTimeOut(15000);
    if (timeout30.isSelected()) portConfig.setTimeOut(30000);

    if (bps2400.isSelected()) portConfig.setBps(2400);
    if (bps4800.isSelected()) portConfig.setBps(4800);
    if (bps9600.isSelected()) portConfig.setBps(9600);
    if (bps19200.isSelected()) portConfig.setBps(19200);

    if (databits5.isSelected()) portConfig.setDataBits(SerialPort.DATABITS_5);
    if (databits6.isSelected()) portConfig.setDataBits(SerialPort.DATABITS_6);
    if (databits7.isSelected()) portConfig.setDataBits(SerialPort.DATABITS_7);
    if (databits8.isSelected()) portConfig.setDataBits(SerialPort.DATABITS_8);

    if (stopbits1.isSelected()) portConfig.setStopBits(SerialPort.STOPBITS_1);
    if (stopbits15.isSelected()) portConfig.setStopBits(SerialPort.STOPBITS_1_5);
    if (stopbits2.isSelected()) portConfig.setStopBits(SerialPort.STOPBITS_2);

    if (parityNONE.isSelected()) portConfig.setParity(SerialPort.PARITY_NONE);
    if (parityODD.isSelected()) portConfig.setParity(SerialPort.PARITY_ODD);
    if (parityEVEN.isSelected()) portConfig.setParity(SerialPort.PARITY_EVEN);
    if (parityMARK.isSelected()) portConfig.setParity(SerialPort.PARITY_MARK);
    if (paritySPACE.isSelected()) portConfig.setParity(SerialPort.PARITY_SPACE);

    return portConfig;

  }

  //////////////////////////////////////////////////////////////////////////////////////////
  public void buildGUI() {
    setupMenuBar();
    layoutComponents();
  }

  //////////////////////////////////////////////////////////////////////////////////////////
  public void setupMenuBar() {
    portMenu.add(portCOM1);
    portMenu.add(portCOM2);
    portMenu.add(portCOM3);
    portMenu.add(portCOM4);
    portButtonGroup.add(portCOM1);
    portButtonGroup.add(portCOM2);
    portButtonGroup.add(portCOM3);
    portButtonGroup.add(portCOM4);

    timeoutMenu.add(timeout01);
    timeoutMenu.add(timeout05);
    timeoutMenu.add(timeout10);
    timeoutMenu.add(timeout15);
    timeoutMenu.add(timeout30);
    timeoutButtonGroup.add(timeout01);
    timeoutButtonGroup.add(timeout05);
    timeoutButtonGroup.add(timeout10);
    timeoutButtonGroup.add(timeout15);
    timeoutButtonGroup.add(timeout30);

    bpsMenu.add(bps2400);
    bpsMenu.add(bps4800);
    bpsMenu.add(bps9600);
    bpsMenu.add(bps19200);
    bpsButtonGroup.add(bps2400);
    bpsButtonGroup.add(bps4800);
    bpsButtonGroup.add(bps9600);
    bpsButtonGroup.add(bps19200);

    databitsMenu.add(databits5);
    databitsMenu.add(databits6);
    databitsMenu.add(databits7);
    databitsMenu.add(databits8);
    databitsButtonGroup.add(databits5);
    databitsButtonGroup.add(databits6);
    databitsButtonGroup.add(databits7);
    databitsButtonGroup.add(databits8);

    stopbitsMenu.add(stopbits1);
    stopbitsMenu.add(stopbits15);
    stopbitsMenu.add(stopbits2);
    stopbitsButtonGroup.add(stopbits1);
    stopbitsButtonGroup.add(stopbits15);
    stopbitsButtonGroup.add(stopbits2);

    parityMenu.add(parityNONE);
    parityMenu.add(parityODD);
    parityMenu.add(parityEVEN);
    parityMenu.add(parityMARK);
    parityMenu.add(paritySPACE);
    parityButtonGroup.add(parityNONE);
    parityButtonGroup.add(parityODD);
    parityButtonGroup.add(parityEVEN);
    parityButtonGroup.add(parityMARK);
    parityButtonGroup.add(paritySPACE);

    menuBar.add(portMenu);
    menuBar.add(timeoutMenu);
    menuBar.add(bpsMenu);
    menuBar.add(databitsMenu);
    menuBar.add(stopbitsMenu);
    menuBar.add(parityMenu);

    setJMenuBar(menuBar);
  }

  //////////////////////////////////////////////////////////////////////////////////////////
  public void layoutComponents() {
    frameContainer = getContentPane();
    frameContainer.setLayout(null);
//    textField.setBounds(100,100,200,40);
//    frameContainer.add(textField);
  }

  //////////////////////////////////////////////////////////////////////////////////////////
  public void setupEventHandlers() {
//    addWindowListener(new WindowHandler());
//    addWindowListener(new WindowAdapter() { public void windowClosing(WindowEvent e) { this.mFinished = true; } } );
    addWindowListener(this);

/*
    portCOM1.addItemListener(new ItemHandler());
    portCOM2.addItemListener(new ItemHandler());
    portCOM3.addItemListener(new ItemHandler());
    portCOM4.addItemListener(new ItemHandler());
    timeout01.addItemListener(new ItemHandler());
    timeout05.addItemListener(new ItemHandler());
    timeout10.addItemListener(new ItemHandler());
    timeout15.addItemListener(new ItemHandler());
    timeout30.addItemListener(new ItemHandler());
    bps2400.addItemListener(new ItemHandler());
    bps4800.addItemListener(new ItemHandler());
    bps9600.addItemListener(new ItemHandler());
    bps19200.addItemListener(new ItemHandler());
    databits5.addItemListener(new ItemHandler());
    databits6.addItemListener(new ItemHandler());
    databits7.addItemListener(new ItemHandler());
    databits8.addItemListener(new ItemHandler());
    stopbits1.addItemListener(new ItemHandler());
    stopbits15.addItemListener(new ItemHandler());
    stopbits2.addItemListener(new ItemHandler());
    parityNONE.addItemListener(new ItemHandler());
    parityODD.addItemListener(new ItemHandler());
    parityEVEN.addItemListener(new ItemHandler());
    parityMARK.addItemListener(new ItemHandler());
    paritySPACE.addItemListener(new ItemHandler());
*/
  }

  //////////////////////////////////////////////////////////////////////////////////////////
  public static void main(String[] args) {
    System.out.println("Test Main started ...");
    SerialPortConfigurationGUI app = new SerialPortConfigurationGUI();
    SerialPortConfiguration portConfig = new SerialPortConfiguration();
    System.out.println("Vorm Dialog: " + portConfig);
    app.startGUI(portConfig);
    System.out.println("Nach Dialog: " + portConfig);
  }

/*  //////////////////////////////////////////////////////////////////////////////////////////
  public class WindowHandler extends WindowAdapter {
    public void windowClosing(WindowEvent e) {
      SerialPortConfigurationGUI.mFinished = true;
    }
  }

  //////////////////////////////////////////////////////////////////////////////////////////
  public class ItemHandler implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      AbstractButton button = (AbstractButton) e.getItem();
      String label = button.getText();
      if (button.isSelected()) label += " true";
      else label += " false";
      System.out.println(label);
//      textField.setText(label);
    }
  }

  */
}
