package tzi.UserInput;

import tzi.UserInput.Serial.SerialCommunication;
import tzi.UserInput.Serial.SerialPortErrorException;
import javax.comm.SerialPort;

import java.util.Vector;

public class TransponderReader implements Runnable{
   private final static String READ_TRANSPONDER = "R"+SerialCommunication.CR+SerialCommunication.LF;
   private final static String ERROR_STRING     = "E";
   private final static String COM_PORT         = "COM2";
   private Thread mReaderThread ;
   private int mStatus;

   private SerialCommunication mSerialPort;

   public final static int ERROR   = -1;
   public final static int PENDING = -2;
   public final static int READING =  1;
   public final static int WAITING =  2;
   public final static int STARTED =  3;

   private MyTimer        mTimer;

  /**
   *@link aggregation
   *     @associates <{tzi.UserInput.TransponderEventListener}>
   * @directed
   * @supplierCardinality *
   */
  private int attribute1;

  /**
   *@link aggregation
   *     @associates <{tzi.UserInput.StringListener}>
   * @supplierCardinality *
   */
  private java.util.Vector mListenerList;

  public TransponderReader() {
    mStatus = PENDING;
    mSerialPort = new SerialCommunication(COM_PORT, 20000, 9600,
                                           SerialPort.DATABITS_8,
                                           SerialPort.STOPBITS_1,
                                           SerialPort.PARITY_NONE, false, true);
    try{
      mSerialPort.openSerialPort();
    } catch(SerialPortErrorException ex){
        System.err.println("TransponderReader: Can not open port "+COM_PORT );
        //System.exit(-1);
    }

    mReaderThread = new Thread(this);
    mReaderThread.start();

    //mTimer = new MyTimer();
    //mTimer.start();

    mListenerList = new Vector();
  }

  public void run(){
    String mAnswer;
    while(true){
        mAnswer = "";
        mStatus = WAITING;

        waitForTrigger();
        mStatus = STARTED;
        mSerialPort.send(READ_TRANSPONDER);
      try{
        mStatus = READING;
        mAnswer = mSerialPort.readValueUpTo((char)0xd, true);

        if(!mAnswer.equals(ERROR_STRING))
          dispatch(new StringEvent(this, mAnswer));

      } catch(SerialPortErrorException ex){
        // timeout has occured
        mStatus = WAITING;
      }
    }
  }


  private synchronized void waitForTrigger(){
      try{
        wait();
      } catch(InterruptedException ex) {}
  }

  public synchronized void trigger(){
    notifyAll();
  }

  public int getStatus(){
    return mStatus;
  }
  /**
 *     Add an <code>AcquisitionListener</code>
  */
  public synchronized void addStringListener(StringListener l) {
     mListenerList.addElement(l);
  }

  /**
 *     Remove an <code>AcquisitionListener</code>
  */
  public synchronized void removeStringListener(StringListener l) {
    mListenerList.removeElement(l);
  }

  /**
 *     Distribute an <code>AcquisitionEvent</code> object to the
 *     individual event listeners
  */
  private void dispatch(StringEvent evt){
    for (int i = 0;  i < mListenerList.size(); i++){
       ((StringListener)mListenerList.elementAt(i)).stringEntered(evt);
    }
    System.out.println( "TransponderRead: "+evt.getString() );
  }

  private void clockTick()
  {
    trigger();
  }

  private class MyTimer extends Thread {

    MyTimer() {
    }

    public void run(){
     while(true){
       try{
          sleep( 3000 );
          clockTick();
        } catch (InterruptedException ex){}
      }
    }

  }

}