package tzi.UserInput.X11Mouse;

/**
 * @author Zuletzt bearbeitet von $Author: jrei $
 * @version $Revision: 1.8 $ $Date: 2005/04/21 12:05:18 $
 */

public class MouseCoords 
{
    public int x;
    public int y;
    public int button;
    
    private int oldX;
    private int oldY;
    private int oldButton;

    public MouseCoords(int x, int y, int button)
    {
	this.x = x;
        this.oldX = x;
	this.y = y;
        this.oldY = y;
	this.button = button;
        this.oldButton = button;
    }

    /** Setzt alle Variablen der Koordinate neu.
     */
    public void set(int x, int y, int button){
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldButton = this.button;
        this.x = x;
        this.y = y;
        this.button = button;
    }
    
    /** Setzt die X Koordinate der Maus Koordinate
     */
    public void setX(int x){
        this.oldX = this.x;
        this.x = x;
    }
    
    /** Setzt die Y Koordinate der Maus Koordinate
     */
    public void setY(int y){
        this.oldY = this.y;
        this.y = y;
    }

    /** Setzt den Knopf der Maus Koordinate
     */
    public void setButton(int button){
        this.oldButton = this.button;
        this.button = button;
    }

    /**
     * Wie wurden die Buttons ver�ndert
     *
     * @param old Vergleichszustand
     * @return Released < 0 < Pressed
     */
    public int buttonChanged(MouseCoords old)
    {
	// Pressed, wenn alt == 0 != neu
	if(old.button == 0 && button > 0)
	    return button;

	// Released, wenn alt > 0 && neu == 0
	else if(old.button != 0 && button == 0)
	    return -old.button;
	/*
	 * Der Released Zustand wurde nicht erkannt:
	 * alt != 0 neu
	 * => return Pressed
	 */
	else if(old.button != button)
	    return button;

	// alles beim alten
	return 0;
    }

    /**
     * Wie wurden die Buttons ver�ndert
     *
     * @param old Vergleichszustand
     * @return Released < 0 < Pressed
     */
    public int buttonChanged()
    {
	/* Pressed, wenn alt == 0 != neu */
	if(this.oldButton == 0 && this.button > 0)
	    return this.button;

	/* Released, wenn alt > 0 && neu == 0 */
	else if(this.oldButton != 0 && this.button == 0)
	    return -oldButton;
	/*
	 * Der Released Zustand wurde nicht erkannt:
	 * alt != 0 neu
	 * => return Pressed
	 */
	else if(this.oldButton != this.button)
	    return this.button;

	/* alles beim alten */
	return 0;
    }
    
    /** Returns the values of the coordinate.
     * The values and variables are seperated by a';'.
     * @return String the coordinates and the button.
     */
    public String toString(){
        return "x=" + this.x + ";y=" + this.y + ";button=" + this.button;
    }

}

/*
 * $Log: MouseCoords.java,v $
 * Revision 1.8  2005/04/21 12:05:18  jrei
 * mouse logging
 *
 * Revision 1.7  2005/03/04 13:20:12  jrei
 * bugfix nativ code scaled the coordinates
 *
 * Revision 1.6  2005/02/27 20:18:00  jrei
 * restructuring for xml service\nfirst tests
 *
 */
