package tzi.UserInput.X11Mouse;

import java.util.Calendar;
import java.util.ResourceBundle;
/**
 * Der X11 Maustreiber
 *
 * @author Zuletzt bearbeitet von $Author: jrei $
 * @version $Revision: 1.10 $ $Date: 2005/04/21 12:05:18 $
 */

public class MouseDriver implements Runnable
{
    
    private static final int MOUSE_EVENT_REFRESH_SPACE_X = 0;

    private static final int MOUSE_EVENT_REFRESH_SPACE_Y = 0;

    /**
     * Der eigene Thread
     */
    private Thread myThread;

    /**
     * Solange true => Thread aktiv
     */
    private boolean isRunning;

    /**
     * Die Maus
     */
    private MouseInp maus;

    /** 
     * Die Koordinate der Maus.
     */
    private MouseCoords mouseCoordinate;
    
    /**
     * Der EventListener
     */
    private MouseEventListener myListener;

    /**
     * Die letzte ausgelesene X Koordinate.
     */
    private int currentX = 20;
    
    /**
     * Die letzte ausgelesene Y Koordinate.
     */
    private int currentY = 20;
    
    /**
     * Der zuletzt angegebene Button Zustand.
     */
    private int currentButton = 0;

    private java.io.FileOutputStream logStream;

    public static ResourceBundle tziConfig = ResourceBundle.getBundle("tzi.config");
    
    /**
     * Konstruktor
     */
    public MouseDriver()
    {
	myThread = null;
	isRunning = false;
	myListener = null;
        /* Logfile stream */
        
        try { 
            this.logStream = new java.io.FileOutputStream(
                tziConfig.getString("logdir") +
                tziConfig.getString("mouse_log"),true);
        } catch (java.io.FileNotFoundException ex){
            ex.printStackTrace();
        }
	maus = new MouseInp();
        this.mouseCoordinate = new MouseCoords(40,40,0);
    }

    /**
     * Bekommt den Thread, in dem er l�uft
     *
     * @param thread der Thread
     */
    public void setThread(Thread thread)
    {
	myThread = thread;
	isRunning = true;
    }

    /**
     * Bekommt den Listener
     */
    public void setListener(MouseEventListener listener)
    {
	myListener = listener;
    }

    /**
     * Stoppt den Thread
     */
    public void stop()
    {
	isRunning = false;
        try {
            this.logStream.close();
        } catch (java.io.IOException ex){
            ex.printStackTrace();
        }
    }

    /**
     * Die Schleife
     */
    public void run()
    {
	if(myThread != null)
	{
	    while(isRunning)
	    {
		if(myListener != null){
                    // jrei - exchanged old native interface
                    // this.mouseCoordinate = this.maus.getMouseCoords();
                    this.maus.getMouseCoordsNew(this.mouseCoordinate);
                    /* Überprüfe wie stark sich die koordinaten geändert haben.
                     * Ein Event wird nur ausgelöst, wenn die Änderungen größer als die 
                     * REPRESH_SPACES sind. */
                    if (this.mouseCoordinate.x - MOUSE_EVENT_REFRESH_SPACE_X > this.currentX 
                        || this.mouseCoordinate.x + MOUSE_EVENT_REFRESH_SPACE_X < this.currentX
                        || this.mouseCoordinate.y - MOUSE_EVENT_REFRESH_SPACE_Y > this.currentY 
                        || this.mouseCoordinate.y + MOUSE_EVENT_REFRESH_SPACE_Y < this.currentY
                        || this.mouseCoordinate.buttonChanged() != 0){
                        myListener.newEvent(this.mouseCoordinate);
                        this.currentX = this.mouseCoordinate.x;
                        this.currentY = this.mouseCoordinate.y;
                        // Debug: System.out.println(this.mouseCoordinate.toString());
                        if (this.mouseCoordinate.buttonChanged() != 0) {
                            try {
                                this.logStream.write((Calendar.getInstance().getTime().toString() + ";").getBytes());
                                this.logStream.write((this.mouseCoordinate.toString()  + "\n").getBytes());
                            } catch (java.io.IOException ex){
                                ex.printStackTrace();
                            }
                        }
                        this.currentButton = this.mouseCoordinate.button;
                    }
                }
		try
		{
		    myThread.sleep(75);
		}
		catch(Exception e)
		{
		    e.printStackTrace();
		}
	    }
	}
	else
	{
	    System.out.println("[X11Mouse]\t Thread war noch nicht gestartet");
	}
    }
}

/*
 * $Log: MouseDriver.java,v $
 * Revision 1.10  2005/04/21 12:05:18  jrei
 * mouse logging
 *
 * Revision 1.9  2005/03/04 14:16:42  jrei
 * no debug
 *
 * Revision 1.8  2005/03/04 13:20:12  jrei
 * bugfix nativ code scaled the coordinates
 *
 * Revision 1.7  2005/02/27 20:18:00  jrei
 * restructuring for xml service\nfirst tests
 *
 */
