package tzi.UserInput.X11Mouse;

/**
 * Der EventListener des X11 Maustreibers
 *
 * @author Zuletzt bearbeitet von $Author: jrei $
 * @version $Revision: 1.4 $ $Date: 2005/02/27 20:18:00 $
 */

import tzi.UserInput.X11Mouse.MouseCoords;

public abstract class MouseEventListener {
    /**
     * Die aktuellen Koordinaten
     */
    protected MouseCoords myCoords;
    
    /**
     * Die alten Koordinaten
     */
    private MouseCoords oldCoords;
    
    public MouseEventListener() {
        oldCoords = new MouseCoords(0, 0, 0);
    }
    
    protected void newEvent(MouseCoords coords) {
        myCoords = coords;
        
        mouseEvent();
        
        // jrei 	int changed = myCoords.buttonChanged(oldCoords);
        int changed = myCoords.buttonChanged();
        if(changed != 0) {
            buttonEvent(changed);
        }
        oldCoords = myCoords;
    }
    
    abstract public void mouseEvent();
    abstract public void buttonEvent(int changed);
}

/*
 * $Log: MouseEventListener.java,v $
 * Revision 1.4  2005/02/27 20:18:00  jrei
 * restructuring for xml service\nfirst tests
 *
 */
