package tzi.WearableInterface;

/**
 * Das Input Center
 * @author Zuletzt bearbeitet von $Author: jrei $
 * @version $Revision: 1.4 $ $Date: 2005/03/04 18:23:03 $
 */

import tzi.UserInput.*;
import tzi.UserInput.X11Mouse.*;
import tzi.UserInput.FileTransponder.*;
import java.util.Vector;

public class InputCenter
{

    protected InputCenter() 
    {
	mFocus = null;
	mListeners = new java.util.Vector();

	// Init Lucky Mouse Converter
	// jrei: mLuckyMouse = new LuckyMouse( new MixAdaptSpeedFilter( 1.0, 9 ) );
	mLuckyMouse = new LuckyMouse( new Pos2PosFilter() );
	
	// Mautreiber instanziieren
	MouseDriver mMouseDriver = new MouseDriver();
	Thread mausTreiberThread = new Thread(mMouseDriver);
	mMouseDriver.setThread(mausTreiberThread);

	X11MouseEvent mausEvent = new  X11MouseEvent(this);
	mMouseDriver.setListener(mausEvent);

	mausTreiberThread.start();

	// Transponder initialisieren
	FileTransponder myTransponder = new FileTransponder();
	Thread transponderThread = new Thread(myTransponder);
	myTransponder.setThread(transponderThread);
	
	TransponderEventListener myListener = new TransponderEventListener(this);
	myTransponder.setListener(myListener);

	transponderThread.start();
	
    }

    public void addInputReceiver(InputReceiver i  ) {
      mListeners.add( i );
    }

    public void removeInputReceiver(InputReceiver ir ) {
      int i;
      InputReceiver ir2;
      boolean stillOnline;

      mListeners.remove( ir );

      if( ir.getWIComponent() == mFocus ) {
          // sind noch andere InputReceiver der Komponente vorhanden???
          stillOnline = false;
          for( i=0; i<mListeners.size(); i++ ) {
              ir2 = (InputReceiver)(mListeners.elementAt( i ));
              if( ir2.getWIComponent() == mFocus ) stillOnline = true;
          }
          // ... sonst Fokus loeschen
          if( !stillOnline ) {
              mFocus = null;
              focusCleared();
          }
      }

    }

    public static InputCenter getInstance()
    {
	if (instance == null) 
	{ 
	    instance = new tzi.WearableInterface.InputCenter(); 
	}
	return instance;
    }

    public void requestFocus(WIComponent c) 
    {
	if( c!=mFocus ) 
	{
	    if( mFocus != null ) 
	    {
		mFocus.focusTaken();
		focusCleared();
	    }

	    mFocus = c;

	    if( mFocus != null ) 
	    {
		mFocus.focusGiven();
		focusGiven();
	    }
	}
    }

    private void focusGiven() 
    {
        int     i;
        InputReceiver ir;
	
        // Check for Input Properties
        for( i=0; i<mListeners.size(); i++ ) 
	{
            ir = (InputReceiver)(mListeners.elementAt( i ));
            if( ir.getWIComponent() == mFocus ) 
	    {
		switch( ir.getEventID() ) 
		{
		    case MENULISTPOS_EVENT:
			mLuckyMouse.newEntryCount( ir.getEntryCount() );
			break;
                }
            }
        }
    }

    private void focusCleared() 
    {
        // Reset Input Properties
        mLuckyMouse.newEntryCount( 0 );
    }

    private void dispatchEvent( InputCenterEvent e ) {

      int     i;
      InputReceiver ir;
      Vector        tellEm = new Vector();

      // erstmal alle in eine Liste packen
      for( i=0; i<mListeners.size(); i++ ) {
        ir = (InputReceiver)mListeners.elementAt( i );
        if( ir.getEventID()==e.getID() ) {
          if( (ir.getWIComponent()==mFocus)||(!ir.getOnlyWhenFocus()) ) {
            tellEm.add( ir.getWIComponent() );
          }
        }
      }

      // danach bescheidgeben
      for( i=0; i<tellEm.size(); i++ ) {
          ((WIComponent)tellEm.get( i )).inputEventArrives( e );
      }
    }

    public void buttonPressed(int buttonEvent)
    {
	// rechte Maustate
	//if(buttonEvent == CONTEXT_EVENT)
	//  dispatchEvent( new InputCenterEvent( this, PRECONTEXT_EVENT ));

	// mitte Maustate
	//if(buttonEvent == TRIGGER_EVENT)
	//  dispatchEvent( new InputCenterEvent( this, PRECONTEXT_EVENT ));

	// linke Maustate
	if(buttonEvent == OK_EVENT)
	    dispatchEvent( new InputCenterEvent( this, PREOK_EVENT));
    }

    public void buttonReleased(int buttonEvent)
    {
	// rechte Maustate
	//if(buttonEvent == CONTEXT_EVENT)
	//  dispatchEvent( new InputCenterEvent( this, CONTEXT_EVENT ));

	// mitte Maustate
	//if(buttonEvent == TRIGGER_EVENT)
	//  dispatchEvent( new InputCenterEvent( this, CONTEXT_EVENT ));

	// linke Maustate
	if(buttonEvent == OK_EVENT)
	    dispatchEvent( new InputCenterEvent( this, OK_EVENT));
    }


    /**
     * Ein neuer RFID wurde gescannt
     * 
     * @param id Der gescannte Wert
     */
    public void newTransponderEvent(String id)
    {
	
    }

    /**
     * ist die Maus bewegt worden, so wird dies hier mitgeteilt
     *
     * @param xPos neue X-Koordinate
     * @param yPos meue Y_Koordinate
     */
    public void mouseMoved(int xPos, int yPos)
    {
	dispatchEvent(new InputCenterEvent(this, 
					   MENULISTPOS_EVENT, 
					   mLuckyMouse.calc(xPos -320)));
//					   yPos / 100));
    }

    public void stringEntered( StringEvent e )
    {
    	dispatchEvent( new InputCenterEvent( this, 
					     COMPONENT_EVENT, 
					     e.getString() ) );
    }

    public void triggerDevice( int id )
    {
	switch( id ) {
	    case 0:
		mTransponderReader.trigger();
		break;
	}
    }

    public final static int DUMMY = 100;

    // Button Events
    public final static int PREOK_EVENT = 7;
    public final static int OK_EVENT = 6;
    public final static int PRECONTEXT_EVENT = 5;
    public final static int CONTEXT_EVENT = 3;
    public final static int PRETRIGGER_EVENT = 4;
    public final static int TRIGGER_EVENT = 1;

    // Transponder Event
    public final static int COMPONENT_EVENT = 2;
    // Coordinate Events
    public final static int MENULISTPOS_EVENT = 0;
    public final static int THREEDEEX_EVENT = 8;
    public final static int THREEDEEY_EVENT = 9;
    public final static int THREEDEEZ_EVENT = 10;

    //private DIMouseDriver mDIMouseDriver;

    private TransponderReader mTransponderReader;

    private MultiInputDevice mMultiInputDevice;

    //private ThreeDeeZDevice mThreeDeeZDevice;
    
    /**
     * @link aggregationByValue
     * @directed
     */
    private LuckyMouse mLuckyMouse;

    /**
     *@link aggregation
     *     @associates <oiref:InputReceiver:oiref>
     * @directed
     * @supplierCardinality *
     * @supplierRole listeners
     */
    private java.util.Vector mListeners;

    /**
     * @link
     * @shapeType PatternLink
     * @pattern Singleton
     * @supplierRole Singleton factory
     */
    /*# private InputCenter _inputCenter; */
    private static InputCenter instance = null;

    /**
     * @directed
     * @link aggregation
     * @supplierCardinality 0..1
     * @supplierRole focus*/
    private WIComponent mFocus;
}
