/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.WearableInterface;

import javax.swing.ImageIcon;


public class MenuEntry {

  private Object        mObject;
  private int           mID;
  private ImageIcon     mIconNormal;
  private ImageIcon     mIconPressed;
  private Object        mSource;

  public MenuEntry( Object source, Object obj, int id, ImageIcon iconNormal, ImageIcon iconPressed )
  {
    mSource = source;
    mObject = obj;
    mID = id;
    mIconNormal = iconNormal;
    mIconPressed = iconPressed;
  }

  public MenuEntry( Object source, Object obj, int id )
  {
    mSource = source;
    mObject = obj;
    mID = id;
    mIconNormal = null;
    mIconPressed = null;
  }

  public Object getSource()
  {
    return mSource;
  }

  public Object getObject()
  {
    return mObject;
  }

  public int getID()
  {
    return mID;
  }

  public ImageIcon getIcon( boolean pressed )
  {
    if( pressed ) return mIconPressed;
    else return mIconNormal;
  }

  public void setIcon( ImageIcon iconNormal, ImageIcon iconPressed )
  {
      mIconNormal = iconNormal;
      mIconPressed = iconPressed;
  }

  public String toString()
  {
    return mObject.toString();
  }

}
