/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.WearableInterface;


public class MenuListPos {
    
    private double           mDPos;
    private int              mSelection;
    private int              mInnerBegin;
    private int              mInnerEnd;
    private boolean          mEnableInnerSelection;
    
    public MenuListPos( double dpos ) {
        mDPos = dpos;
        mSelection = getIPos();
        mEnableInnerSelection = false;
    }
    
    public MenuListPos( MenuListPos n, MenuListPos o ) {
        double diff;
        
        mDPos = n.getDPos();
        diff = n.getDPos() - (double)o.getSelection();
	/* Snap to selection */
        if( (diff < -0.9) || (diff > 0.9) ) {
            mSelection = n.getIPos();
        } else {
            mSelection = o.getSelection();
        }
        mEnableInnerSelection = false;
    }
    
    public MenuListPos( MenuListPos n, MenuListPos o, int innerBegin, int innerEnd ) {
        this( n, o );
        mEnableInnerSelection = true;
        mInnerBegin = innerBegin;
        mInnerEnd = innerEnd;
    }
    
    public void clip( int max ) {
        if( mDPos < 0.0 ) {
            mDPos = 0.0;
        }
        else if( mDPos > (double)(max - 1) ) {
            mDPos = (double)(max - 1);
        }
        if( mSelection < 0 ) {
            mSelection = 0;
        }
        else if( mSelection > max - 1 ) {
            mSelection = max - 1;
        }
        
        if( mEnableInnerSelection ) {
            if( mInnerBegin < 0 ) {
                mInnerBegin = 0;
            }
            else if( mInnerBegin > max - 1 ) {
                mInnerBegin = max - 1;
            }
            if( mInnerEnd < mInnerBegin ) {
                mInnerEnd = mInnerBegin;
            }
            else if( mInnerEnd > max - 1 ) {
                mInnerEnd = max - 1;
            }
        }
    }

    public double getDPos() {
        return mDPos;
    }
    
    public int getIPos() {
        return (int)(mDPos+0.5);
    }
    
    public double getDiff() {
        return getDPos() - (double)getIPos();
    }
    
    public int getSelection() {
        return mSelection;
    }
    
    public boolean getInnerSelectionEnabled() {
        return mEnableInnerSelection;
    }
    
    public int getInnerSelectionBegin() {
        return mInnerBegin;
    }
    
    public int getInnerSelectionEnd() {
        return mInnerEnd;
    }
}
