/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.WearableInterface;

import java.util.Vector;
import javax.swing.ImageIcon;


public class MenuVector {

  /**
   *@link aggregation
   *     @associates <{tzi.WearableInterface.MenuEntry}>
   * @supplierCardinality *
   * @directed
   */
  private java.util.Vector mVector;

  public MenuVector()
  {
    mVector = new Vector();
  }

  public void add( Object source, Vector v, int id, ImageIcon iconNormal, ImageIcon iconPressed )
  {
    for( int i=0; i<v.size(); i++ ) {
      mVector.add( new MenuEntry( source, v.elementAt( i ), id, iconNormal, iconPressed ) );
    }
  }

  public void add( Object source, Object o, int id, ImageIcon iconNormal, ImageIcon iconPressed )
  {
    mVector.add( new MenuEntry( source, o, id, iconNormal, iconPressed ) );
  }

  public MenuEntry get( int i )
  {
	if( (i>=0)&&(i<mVector.size()) ) {
    	return (MenuEntry)(mVector.elementAt( i ));
    } else {
    	return null;
    }
  }

  public int size()
  {
    return mVector.size();
  }

  public Object getObject( int i )
  {
    return ((MenuEntry)(mVector.elementAt( i ))).getObject();
  }

  public int getID( int i )
  {
    return ((MenuEntry)(mVector.elementAt( i ))).getID();
  }

  public ImageIcon getIcon( int i, boolean pressed )
  {
    return ((MenuEntry)(mVector.elementAt( i ))).getIcon( pressed );
  }

  public void setIcon( int i, ImageIcon iconNormal, ImageIcon iconPressed )
  {
      ((MenuEntry)(mVector.elementAt( i ))).setIcon( iconNormal, iconPressed );
  }

}
