/* Generated by Together */

package tzi.WearableInterface;

public class MixAdaptSpeedFilter implements MoveFilter {
    /**
     * @link aggregationByValue
     */
    private Pos2PosFilter mPos2pos;
    
    /**
     * @link aggregationByValue
     */
    private Pos2SpeedFilter mPos2speed;
    
    private int mPos2posCount;
    private int mPos2speedCount;
    private double mSpeed;
    private boolean mScrolling;
    private int mInnerSelectionCount;
    private MenuListPos mLastListPos;
    
    public MixAdaptSpeedFilter( double fac, int innerSelectionCount ) {
        mPos2pos = new Pos2PosFilter();
        mPos2speed = new Pos2SpeedFilter( fac );
        mSpeed = 0.0;
        mScrolling = false;
        mInnerSelectionCount = innerSelectionCount;
        mLastListPos = new MenuListPos( 0.0 );
    }
    
    public void reset() {
        mPos2pos.reset();
        mPos2speed.reset();
        mSpeed = 0.0;
        mScrolling = false;
        mLastListPos = new MenuListPos( 0.0 );
    }
    
    public void setEntryCount( int entryCount ) {
        mPos2speedCount = entryCount; //-6;
        mPos2posCount = mInnerSelectionCount;
        if( mPos2posCount > entryCount ) {
            mPos2posCount = entryCount;
            mPos2speedCount = 0;
        }
        mPos2pos.setEntryCount( mPos2posCount );
        mPos2speed.setEntryCount( mPos2speedCount );
    }
    
    /** inputPos: -1.0 <..< 1.0 */
    public MenuListPos calcListPos( double smoothInputPos, double inputPos ) {
        MenuListPos pospos;
        MenuListPos speedpos;
        double oiput;
        MenuListPos r;
        
        pospos = mPos2pos.calcListPos( smoothInputPos, inputPos );
        if( mPos2speedCount == 0 ) {
            mLastListPos = new MenuListPos( pospos, mLastListPos );
            return mLastListPos;
        } else {
            if( mScrolling ) {
                if ( ((pospos.getIPos() > 1) && (mSpeed < 0.0))
                    || ((pospos.getIPos() < mPos2posCount - 2) && (mSpeed > 0.0)) ) {
                    // Scrolling stoppen
                    mScrolling = false;
                    //System.out.println( "STOPP SCROLLING" );
                }
            }
            if( (pospos.getIPos() == 0) 
                || (pospos.getIPos() == mPos2posCount - 1) 
                || mScrolling ) {
                if( !mScrolling ) { // Scrolling mit aktueller Position starten
                    mSpeed = mPos2pos.getSpeed();
                    if( (mSpeed < 0.1) && (mSpeed > -0.1) ) { // Mindestgeschwindigkeit setzen
                        if( pospos.getIPos() == 0 ) {
                            mSpeed = -0.1;
                        }
                        else {
                            mSpeed = 0.1;
                        }
                    }
                    mScrolling = true;
                    //System.out.println( "START SCROLLING" );
                }
                oiput = mSpeed;
            } else { // kein Scrolling
                oiput = 0.0;
            }
            speedpos = mPos2speed.calcListPos( oiput, oiput );
            r = new MenuListPos( speedpos.getDPos() + pospos.getDPos() 
                                   - (double)((mInnerSelectionCount - 1) / 2) );
            r.clip( mPos2speedCount );
            mLastListPos = new MenuListPos( r, mLastListPos,
                speedpos.getIPos() - (mInnerSelectionCount - 1) / 2 + 1,
                speedpos.getIPos() + (mInnerSelectionCount - 1) / 2 - 1 );
            mLastListPos.clip( mPos2speedCount );
            return mLastListPos;
        }
    }
    
    
}
