/* Generated by Together */

package tzi.WearableInterface;

public class MixFilter implements MoveFilter {
    /**
     * @link aggregationByValue
     */
    private Pos2PosFilter mPos2pos;
    
    /**
     * @link aggregationByValue
     */
    private Pos2SpeedFilter mPos2speed;
    
    private int mPos2posCount;
    private int mPos2speedCount;
    
    public MixFilter( double fac ) {
        mPos2pos = new Pos2PosFilter();
        mPos2speed = new Pos2SpeedFilter( fac );
    }
    
    public void reset() {
        mPos2pos.reset();
        mPos2speed.reset();
    }
    
    public void setEntryCount( int entryCount ) {
        mPos2speedCount = entryCount - 6;
        mPos2posCount = 7;
        if( mPos2posCount > entryCount ) {
            mPos2posCount = entryCount;
            mPos2speedCount = 0;
        }
        mPos2pos.setEntryCount( mPos2posCount );
        mPos2speed.setEntryCount( mPos2speedCount );
    }
    
    /** inputPos: -1.0 <..< 1.0 */
    public MenuListPos calcListPos( double smoothInputPos, double inputPos ) {
        MenuListPos pospos;
        MenuListPos speedpos;
        double oiput;
        
        pospos = mPos2pos.calcListPos( smoothInputPos, inputPos );
        if ( mPos2speedCount == 0 ) {
            return pospos;
        } else {
            if ( pospos.getIPos() == 0 ) {
                oiput = -0.3;
            }
            else if ( pospos.getIPos() == mPos2posCount - 1 ) {
                oiput = 0.3;
            }
            else {
                oiput = 0.0;
            }
            speedpos = mPos2speed.calcListPos( oiput, oiput );
            return new MenuListPos( speedpos.getDPos() + pospos.getDPos() );
        }
    }
}
