/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.WearableInterface;


public class Pos2PosFilter implements MoveFilter {
    
    private int mEntryCount;
    private double mLastPos;
    private double mSpeed;
    
    public Pos2PosFilter() {
        mEntryCount = 0;
        mSpeed = 0.0;
        mLastPos = 0.0;
    }
    
    public void reset() {
        mLastPos = 0.0;
        mSpeed = 0.0;
    }
    
    public void setEntryCount( int entryCount ) {
        mEntryCount = entryCount;
    }
    
    public MenuListPos calcListPos( double smoothInputPos, double inputPos ) {
        double i;
        i = (smoothInputPos + 1.0) / 2.0 * (double)mEntryCount - 0.5;
	// Debug: System.out.print("calcListPos: " + i + " \t");
        if( i < 0.0 ) {
            i = 0.0;
        }
        else if( i > mEntryCount - 1.0 ) {
            i = mEntryCount - 1.0;
        }
        mSpeed = (i - mLastPos) * 0.5 + mSpeed * 0.5;
        mLastPos = i;   
	// Debug: System.out.println("calcListPos: " + i);
        return new MenuListPos( i );
    }
    
    public double getSpeed() {
        return mSpeed;
    }
}

/*
 * $Log: Pos2PosFilter.java,v $
 * Revision 1.4  2005/03/04 18:23:03  jrei
 * tested working cebit version
 *
 * Revision 1.3  2005/03/04 14:54:06  jrei
 * utf8
 *
 * Revision 1.2  2005/02/08 15:22:03  jrei
 * perfomance tweaks and arm compiler option within INSTALL
 *
 */
