/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.WearableInterface;


public class Pos2SpeedFilter implements MoveFilter {
    
    private int mEntryCount;
    private double mNowPos;
    private double mFac;
    
    public Pos2SpeedFilter( double fac ) {
        mEntryCount = 0;
        mFac = fac;
        mNowPos = 0.0;
    }
    
    public void reset() {
        mNowPos = 0.0;
    }
    
    public void setEntryCount( int entryCount ) {
        mEntryCount = entryCount;
    }
    
    public MenuListPos calcListPos( double smoothInputPos, double inputPos ) {
        mNowPos += smoothInputPos * mFac;
        if( mNowPos < 0.0 ) {
            mNowPos = 0.0;
        }
        else if( mNowPos > (double)mEntryCount - 1.0 ) {
            mNowPos = (double)mEntryCount - 1.0;
        }
        return new MenuListPos( mNowPos );
    }
    
}

/*
 * $Log: Pos2SpeedFilter.java,v $
 * Revision 1.3  2005/03/04 14:54:06  jrei
 * utf8
 *
 * Revision 1.2  2005/02/08 15:22:03  jrei
 * perfomance tweaks and arm compiler option within INSTALL
 *
 */