/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.WearableInterface;

import javax.swing.*;
import java.awt.*;


public class PowerIndicator extends JPanel {

  private JProgressBar  mBattery;
  private MyTimer       mTimer;
  private boolean       mVisible;

  public PowerIndicator()
  {
    super();

    if( !SystemStatus.getPowerStatus().getOnline() ) {
    try {
        mBattery = new JProgressBar();
        mBattery.setOrientation( JProgressBar.VERTICAL );
        mBattery.setFont( Toolbox.getFont() );
        mBattery.setString( "..." );
        mBattery.setStringPainted( true );
        mBattery.setBorderPainted( false );
        mBattery.setBackground( new Color( 80, 80, 80 ) );
        mBattery.setForeground( new Color( 0, 255, 0 ) );
        setLayout( new BorderLayout() );
        add( mBattery, BorderLayout.CENTER );
    } catch( Exception e ) {
    }

    clockTick();
    showPower();

    mTimer = new MyTimer();
    mTimer.setPriority( Thread.MIN_PRIORITY );
    mTimer.start();
    }
  }

  public void showPower()
  {
    add( mBattery, BorderLayout.CENTER );
    mVisible = true;
    MyOnceTimer t = new MyOnceTimer();
    t.start();
  }

  private void clockTick()
  {
    int p = SystemStatus.getPowerStatus().getBatteryLifePercent();
    p-=20; // Reservetank

      if( p>0 ) {
        p=p*100/80;
        mBattery.setForeground( new Color( 0, 255, 0 ) );
        mBattery.setValue( p );
        mBattery.setString( p+"%" );
      } else {
        mBattery.setForeground( new Color( 255, 0, 0 ) );
        mBattery.setValue( 100 );
        mBattery.setString( "0" );
      }

      if( (p<10) && !mVisible ) {
        add( mBattery, BorderLayout.CENTER );
        mVisible = true;
      }

  }

  private void clockTickOnce()
  {
    int p = SystemStatus.getPowerStatus().getBatteryLifePercent();
    p-=20; // Reservetank

    if( !(p<10) ) {
      remove( mBattery );
      mVisible = false;
      repaint();
    }
  }

  private class MyTimer extends Thread {
    MyTimer() {
    }

    public void run(){
     while(true){
       try{
          sleep( 10000 );
          clockTick();
        } catch (InterruptedException ex){}
      }
    }

  }

  private class MyOnceTimer extends Thread {
    MyOnceTimer() {
    }

    public void run(){
       try{
          sleep( 10000 );
          clockTickOnce();
        } catch (InterruptedException ex){}
    }

  }

}

