/**
 * Title:        Winspect<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Tom Nicolai<p>
 * Company:      TZI Bremen<p>
 * @author Tom Nicolai
 * @version 1.0
 */

package tzi.WearableInterface;

import javax.swing.*;
import javax.swing.border.*;
import java.util.Vector;
//import tzi.winspect.Inspector.*;
import java.awt.Font;
import java.awt.*;


public class SelectorList extends Canvas implements WIComponent {
    /**
     * @link aggregation
     */
    private MenuVector                  mMenuVector;
    
    /**
     * @link aggregation
     */
    private InputReceiver               mPosReceiver;
    
    /**
     * @link aggregation
     */
    private InputReceiver               mOKReceiver;
    
    private InputReceiver               mPreOKReceiver;
    
    private boolean			mHasFocus;
    
    /**
     *@link aggregation
     *     @associates <{tzi.WearableInterface.SelectorListEventListener}>
     */
    private java.util.Vector mListeners;
    
    /**
     * @link aggregation
     */
    private SmoothListRenderer    mSmoothRenderer;
    
    /**
     * @link aggregation
     * @directed
     */
    private MenuListPos mMenuListPos;
    
    private Image                   mOffScreenBuffer;
    
    private boolean mFreezePosition;
    
    private Dimension mMaxSize;
    
    
    public SelectorList( MenuVector v ) {
        super();
        
        //mMaxSize();
        
        mFreezePosition = false;
        mOffScreenBuffer = null;
        mSmoothRenderer = new SmoothListRenderer();
        mListeners = new Vector();
        mMenuListPos = new MenuListPos( 0.0 );
        mHasFocus = false;
        mMenuVector = new MenuVector();
        
        mPosReceiver = new InputReceiver( this, InputCenter.MENULISTPOS_EVENT, 0, true );
        mOKReceiver = new InputReceiver( this, InputCenter.OK_EVENT, 0, true );
        mPreOKReceiver = new InputReceiver( this, InputCenter.PREOK_EVENT, 0, true );
        
        setListData( v );
    }
    
    public void connect() {
        // beim InputCenter anmelden
        InputCenter.getInstance().addInputReceiver( mPosReceiver );
        InputCenter.getInstance().addInputReceiver( mOKReceiver );
        InputCenter.getInstance().addInputReceiver( mPreOKReceiver );
    }
    
    public void disconnect() {
        InputCenter.getInstance().removeInputReceiver( mPosReceiver );
        InputCenter.getInstance().removeInputReceiver( mOKReceiver );
        InputCenter.getInstance().removeInputReceiver( mPreOKReceiver );
    }
    
    public void setListData( MenuVector v ) {
        mMenuVector = v;
        mPosReceiver.setEntryCount( v.size() );
    }
    
    public void addSelectorListEventListener( SelectorListEventListener listener ) {
        mListeners.addElement( listener );
    }
    
    public void removeSelectorListEventListener( SelectorListEventListener listener ) {
        mListeners.removeElement( listener );
    }
    
    public void focusGiven() {
        mHasFocus = true;
        repaint();
    }
    
    public void focusTaken() {
        mHasFocus = false;
        repaint();
    }
    
    public void inputEventArrives( InputCenterEvent e ) {
        if( !mHasFocus ) return;
        
        switch( e.getID() ) {
            
            case InputCenter.MENULISTPOS_EVENT:
                if( !mFreezePosition ) {
                    mMenuListPos = e.getMenuListPos();
                    repaint();
                }
                break;
                
            case InputCenter.PREOK_EVENT:
                mFreezePosition = true;
                repaint();
                break;
                
            case InputCenter.OK_EVENT:
                mHasFocus = false;
                repaint();
                MyTimer timer = new MyTimer( 700 );
                timer.start();
                break;
                
        }
    }
    
    public Dimension getPreferredSize() {
        //return new Dimension( 100, 100 );
        return new Dimension( 270, 110 );
    }
    
    /* public Dimension getMaximumSize()
  {
    return new Dimension( 100, 50 );
    }*/
    
    public void update( Graphics g ) {
        
        Graphics gr;
        // Will hold the graphics context from the offScreenBuffer.
        // We need to make sure we keep our offscreen buffer the same size
        // as the graphics context we're working with.
        if (mOffScreenBuffer==null) {
            mOffScreenBuffer = createImage( size().width, size().height );
            //mOffScreenBuffer = createImage( 100, 100 );
        }
        
        // We need to use our buffer Image as a Graphics object:
        gr = mOffScreenBuffer.getGraphics();
        
        paint( gr );
        
        g.drawImage( mOffScreenBuffer, 0, 0, null );
        // And now we transfer the info in the buffer onto the
        // graphics context we got from the browser in one smooth motion.
        
    }
    
    public void paint( Graphics g ) {
        mMenuListPos.clip( mMenuVector.size() );
        // mSmoothRenderer.update( g, size(), mMenuListPos, mMenuVector, mHasFocus, mFreezePosition );
        mSmoothRenderer.update( this, g, size(), mMenuListPos, mMenuVector, mHasFocus, mFreezePosition );
        
    }
    
    private void executeSelection() {
        SelectorListEvent   listEvt = new SelectorListEvent( this, mMenuListPos.getSelection(), mMenuVector.get( mMenuListPos.getIPos() ) );
        for (int i = 0;  i < mListeners.size(); i++){
            ((SelectorListEventListener)mListeners.elementAt(i)).selection( listEvt );
        }
        mFreezePosition = false;
    }
    
    private class MyTimer extends Thread {
        
        private int       mTime;
        
        MyTimer( int time ) {
            mTime = time;
        }
        
        public void run() {
            try {
                sleep( mTime );
                executeSelection();
            } catch( InterruptedException ex ){}
        }
    }
    
}

