/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.WearableInterface;

import java.awt.*;
import javax.swing.ImageIcon;
import java.util.Vector;

public class SmoothListRenderer {
    
    private static final Color SELECT_COLOR = new Color(255,255,0);
    private static final Color ACTIVATE_COLOR = new Color(255,255,255);
    
    
    private MenuListPos mLastPos;
    private MenuVector mLastEntries;
    private boolean mActive;
    private Dimension mD;
    private boolean mButtonDown;
    
    private Image[] menuItemImages;
    private Component c;
    private FontMetrics metrics;
    
    public SmoothListRenderer() {
    }
    
    private void paint( Graphics g ) {
        long t1;
        long t2;
        int yKoordStart;
        int yPosStart;
        int yKoordStep;
        // FontMetrics metrics;
        int y;
        // int         i;
        int subListLen;
        int selI;
        int yKoordOffset;
        int yInnerBegin;
        int yInnerEnd;
        
        t1 = System.currentTimeMillis();
        if (mLastEntries == null) {
            return;
        }
        
        metrics = g.getFontMetrics();
        
        // Clear screen: fill with black color
        g.setColor(new Color(0, 0, 0));
        g.fillRect(0, 0, mD.width, mD.height);
        
        //yKoordStep = metrics.getHeight();//get the height of a letter
        yKoordStep = metrics.getHeight() + 2;//get the height of a letter
        
        // yKoordStart = - (int)(mLastPos.getDiff() * (double) yKoordStep) + yKoordStep / 2;
        yKoordStart = - (int)(mLastPos.getDiff() * (double) yKoordStep) + yKoordStep / 2 - yKoordStep;
        // jrei  yKoordStart = - (int)(mLastPos.getDiff() * yKoordStep) + yKoordStep / 2 - yKoordStep;
        subListLen = mD.height/yKoordStep/2 + 1;
        selI = mLastPos.getIPos();
        
        yKoordOffset = ((mD.height - 33) / 2) - (subListLen - 1) * yKoordStep + 6;
        
        // Obere und untere Liste malen
        if(mActive) {
            g.setFont( Toolbox.getFont() );
            
            if( mLastPos.getInnerSelectionEnabled() ) {
                
                yInnerBegin = yKoordStart + yKoordOffset + 4
                    + (-(selI+1-subListLen)+mLastPos.getInnerSelectionBegin()-1) * yKoordStep;
                yInnerEnd = yKoordStart+yKoordStep*subListLen+yKoordOffset+4
                    + (-(selI)+mLastPos.getInnerSelectionEnd())*yKoordStep;
                
                g.fillRect( 0, yInnerBegin, mD.width, yInnerEnd-yInnerBegin );
                g.setColor( new Color( 0, 50, 0 ) );
                g.drawLine( 0, yInnerBegin-1, mD.width, yInnerBegin-1 );
                g.drawLine( 0, yInnerEnd, mD.width, yInnerEnd );
            }
            g.setColor( SELECT_COLOR ); //yellow
            paintSubList(g, selI + 1 - subListLen, selI + 1, 
			 yKoordStart + yKoordOffset, yKoordStep);
            g.setColor( SELECT_COLOR ); //yellow
            paintSubList(g, selI, selI + subListLen, 
			 yKoordStart+yKoordStep * subListLen+yKoordOffset, yKoordStep);
        }
        
        //Ausgewaehlter Eintrag
        g.setFont( Toolbox.getBigFont() );
        if( mActive ) {
            paintSelectedEntryActive( g, mLastPos.getSelection() );
        } else {
            paintSelectedEntryInactive( g, mLastPos.getSelection() );
        }
        t2 = System.currentTimeMillis();
        // jrei System.out.println("paint(...) needed " + (t2 - t1) + " ms");
    }
    
    private void paintSubList( Graphics g, int iStart, int iEnd, int yStart, int yStep ) {
        int y;
        int i;
        for( i=iStart, y=yStart; i<iEnd; i++, y+=yStep ) {
            if( (i>=0) && (i<mLastEntries.size()) ) {
                paintItem( g, i, 40, y );
            }
        }
    }
    
    private void paintSelectedEntryActive( Graphics g, int i )  {
        int height;
        int y;
        height = 33;
        
        y = (mD.height-height)/2;
        // jrei undo
        g.setColor( new Color( 100, 100, 0 ) );
        g.drawLine( 0, y, mD.width, y );
        g.drawLine( 0, y+height, mD.width, y+height );
        
        if( mButtonDown ) {
            g.setColor( ACTIVATE_COLOR );
        }
        else {
            g.setColor( SELECT_COLOR );
        }
        g.fillRect( 0, y+1, mD.width, height-1 );
        g.setColor( new Color( 0, 0, 0 ) );
        // paintItem( g, i, 40, (mD.height+g.getFontMetrics().getHeight())/2-5 );
        g.drawString(mLastEntries.getObject(i).toString(), 40, 
		     (mD.height+g.getFontMetrics().getHeight()) / 2 - 5 );
        if( mLastEntries.getIcon( i, mButtonDown ) != null ) {
            mLastEntries.getIcon( i, mButtonDown ).paintIcon( null, g, 3, y+2 );
        }
    }
    
    private void paintSelectedEntryInactive( Graphics g, int i ) {
        int height;
        int y;
        height = 33;
        
        y = (mD.height-height)/2;
        g.setColor( new Color( 100, 100, 100 ) );
        g.drawLine( 0, y, mD.width, y );
        g.drawLine( 0, y + height, mD.width, y+height );
        g.setColor( new Color( 200, 200, 200 ) );
        g.fillRect( 0, y + 1, mD.width, height-1 );
        g.setColor(new Color(0, 0, 0));
        //paintItem( g, i, 40, (mD.height+g.getFontMetrics().getHeight())/2-5 );
        g.drawString( mLastEntries.getObject(i).toString(), 40, (mD.height+g.getFontMetrics().getHeight())/2-5 );
        
        if (mLastEntries.getIcon(i, mButtonDown)!=null) {
            mLastEntries.getIcon(i, mButtonDown).paintIcon( null, g, 3, y+2);
        }
    }
    
    /*  private void paintItem( Graphics g, int i, int x, int y )  {
	g.drawString( mLastEntries.getObject( i ).toString(), x, y );
	}
    */
    
    private void paintItem( Graphics g, int i, int x, int y )  {
        // if ((menuItemImages == null) || menuItemImages[i] == null) {
        //     g.drawString( mLastEntries.getObject( i ).toString(), x, y );
        // } else {
        g.drawImage(menuItemImages[i], x, y, c);
        // }
    }
    
    /*public void update(Graphics g, Dimension d, MenuListPos pos, MenuVector menuVector, boolean focus, boolean down) {
      mD = d;
      mLastPos = pos;
      mLastEntries = menuVector;
      mActive = focus;
      mButtonDown = down;
      paint(g);  
      }
    */
    
    public void update(Component c, Graphics g, Dimension d, MenuListPos pos, MenuVector menuVector, boolean focus, boolean down) {
        boolean redrawMenuImages =  
            (mLastEntries != menuVector) 
	    || ( (mLastEntries != null && menuVector != null) 
		 && (mLastEntries.size() != menuVector.size()));
        // jrei System.out.println( "SmoothListRenderer.update() redrawMenuImages=" + redrawMenuImages );
        
        mD = d;
        mLastPos = pos;
        mLastEntries = menuVector;
        mActive = focus;
        mButtonDown = down;
        this.c = c;
        
        metrics = g.getFontMetrics();
        
        if (redrawMenuImages)   {
            menuItemImages = new Image[menuVector.size()];
            for (int i = 0; i < menuItemImages.length; i++) {
                menuItemImages[i] = c.createImage(mD.width, metrics.getHeight() + 3);
                Graphics tmpGraphics = menuItemImages[i].getGraphics();
                tmpGraphics.setFont( Toolbox.getFont() );
                tmpGraphics.setColor( ACTIVATE_COLOR );
                tmpGraphics.drawString( mLastEntries.getObject(i).toString(), 0, metrics.getHeight());
                // jrei System.out.println( "drawString: "+mLastEntries.getObject(i).toString() );
            }
        }
        paint(g);
    }
}

/*
 * $Log: SmoothListRenderer.java,v $
 * Revision 1.4  2005/03/04 14:54:06  jrei
 * utf8
 *
 * Revision 1.3  2005/02/08 15:22:03  jrei
 * perfomance tweaks and arm compiler option within INSTALL
 *
 */
