/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.WearableInterface;

import javax.swing.*;
import java.awt.*;


public class StatusBar extends JPanel {

    private JLabel          mLabel;
    private MyTimer         mMyTimer;

    public StatusBar()
    {
	try {
	    mLabel = new JLabel( " " );
	    mLabel.setFont( Toolbox.getFont() );
	    mLabel.setForeground( Toolbox.getFontColor() );

	    setBackground(Toolbox.getBackground());
	    setLayout( new BorderLayout() );
	    add( mLabel, BorderLayout.CENTER );
	} catch( Exception e ) {
	}
	mMyTimer = null;
    }

    public void message( String txt, int ttl )
    {
	mLabel.setText( txt );
	mMyTimer = new MyTimer( ttl );
	mMyTimer.setPriority( Thread.MIN_PRIORITY );
	mMyTimer.start();
	repaint();
    }

    public void clear()
    {
	mMyTimer = null;
	mLabel.setText( " " );
	repaint();
    }

    private void clockTick( MyTimer timer )
    {
	if( mMyTimer == timer ) {
	    clear();
	}
    }

    private class MyTimer extends Thread {

	private int       mTime;

	MyTimer( int time )
	{
	    mTime = time;
	}

	public void run()
	{
	    try {
		sleep( mTime );
		clockTick( this );
	    } catch( InterruptedException ex ){}
	}
    }
}


