/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.WearableInterface;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.util.ResourceBundle;
import java.awt.Color;

public class Toolbox {
    
    static ResourceBundle mRB;
    
    static public final int     ICON_OK30 = 0;
    static public final int     ICON_CANCEL30 = 1;
    static public final int     ICON_CHECKNONE30 = 2;
    static public final int     ICON_CHECKOK30 = 3;
    static public final int     ICON_LOGOUT30 = 4;
    static public final int     ICON_CAMERA30 = 5;
    static public final int     ICON_EXIT30 = 6;
    static public final int     ICON_CHECKNONEALERT30 = 7;
    static public final int     ICON_BATTERY30 = 8;
    static final int            ICONCOUNT = 9;
    
    static private Border       mBorder;
    static private boolean      mHasBorder;
    static private Font         mFont;
    static private boolean      mHasFont;
    static private Font         mBigFont;
    static private boolean      mHasBigFont;
    static private StatusBar    mStatusBar;
    static private boolean      mHasStatusBar;
    static private String       mImagePath;
    static private ImageIcon[]  mIcons;
    static private MoveFilter   mStdMoveFilter;
    static private boolean      mHasStdMoveFilter;
    
    static {
        mRB = ResourceBundle.getBundle("tzi.WearableInterface.Interface");
        
        mHasBorder = false;
        mHasFont = false;
        mHasBigFont = false;
        mHasStatusBar = false;
        
        mImagePath = mRB.getString( "IconPath" );
        mIcons = new ImageIcon[ICONCOUNT];
        mIcons[ICON_OK30] = new ImageIcon( getImagePath()+"Ok30.jpg" );
        mIcons[ICON_CANCEL30] = new ImageIcon( getImagePath()+"Cancel30.jpg" );
        mIcons[ICON_CHECKNONE30] = new ImageIcon( getImagePath()+"CheckNone30.jpg" );
        mIcons[ICON_CHECKOK30] = new ImageIcon( getImagePath()+"CheckOk30.jpg" );
        mIcons[ICON_LOGOUT30] = new ImageIcon( getImagePath()+"Logout30.jpg" );
        mIcons[ICON_CAMERA30] = new ImageIcon( getImagePath()+"Camera30.jpg" );
        mIcons[ICON_EXIT30] = new ImageIcon( getImagePath()+"Exit30.jpg" );
        mIcons[ICON_CHECKNONEALERT30] = new ImageIcon( getImagePath()+"CheckNoneAlert30.jpg" );
        mIcons[ICON_BATTERY30] = new ImageIcon( getImagePath()+"Battery30.jpg" );
        mHasStdMoveFilter = false;
        
    }
    
    static public Border getBorder() {
        if( !mHasBorder ) {
            mBorder = BorderFactory.createCompoundBorder(
							 BorderFactory.createMatteBorder( 5, 5, 5, 5, new Color( 255, 255, 255 ) ),
							 BorderFactory.createEmptyBorder( 5, 5, 5, 5 ) );
            mHasBorder = true;
        }
        return mBorder;
    }
    
    static public Font getFont() {
        if( !mHasFont ) {
            mFont = new Font( "SansSerif", Font.BOLD, 14 );
            mHasFont = true;
        }
        return mFont;
    }
    
    static public Font getBigFont() {
        if( !mHasBigFont ) {
            mBigFont = new Font( "SansSerif", Font.BOLD, 18 );
            mHasBigFont = true;
        }
        return mBigFont;
    }
    
    static public StatusBar getStatusBar() {
        if( !mHasStatusBar ) {
            mStatusBar = new StatusBar();
            mHasStatusBar = true;
        }
        return mStatusBar;
    }
    
    public static String getImagePath() {
        return mImagePath;
    }
    
    public static ImageIcon getIcon( int id ) {
        return mIcons[id];
    }
    
    public static MoveFilter getStdMoveFilter() {
        if( !mHasStdMoveFilter ) {
            mStdMoveFilter = new Pos2PosFilter();
            mHasStdMoveFilter = true;
        }
        return mStdMoveFilter;
    }
    
    public static Color getFontColor() {
        return new Color(255, 255, 255);// java.awt.Color.WHITE;
    }
    
    public static Color getBackground() {
        return new Color(0, 0, 0);//java.awt.Color.BLACK;
    }    
}
