/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */

 // Einfacher Ringpuffer 0 1 2 3 n
 // 1 Ist das Element, was als naechstes auf dem Ring faellt!

package tzi.util;

import java.util.Vector;

public class RingBuffer {

  private Vector Data;
  private int size=0;

  public RingBuffer(int in) {
   size=in;
   Data = new Vector(size);
  }

  public RingBuffer(){
   size=100;
   Data = new Vector(size);
  }

  public void add(Object in){
   Data.add(in);
   while(Data.size()>size){
    Data.remove(Data.size());
   }
  }

  public void removeLast(){
   if(Data.size()>0){
    Data.remove(Data.size());
   }
  }

  public Object getLastElement(){
   if(Data.size()==0){
    return null;
   }
   return Data.lastElement();
  }

  public Object getElementAt(int in){
   if(Data.size()<in){
    return null;
   }
   return Data.elementAt(in);
  }

  public int size(){
   return Data.size();
  }

  public int maxElements(){
   return size;
  }

  public boolean isEmpty(){
   if(Data.size()==0){
    return true;
   }else{
    return false;
   }
  }

}