package tzi.winspect.DBServices;

/**
 * DBService stellt die Verbindung zur DB her
 * @author Zuletzt bearbeitet von $Author: jrei $
 * @version $Revision: 1.5 $ $Date: 2005/02/27 20:18:00 $
 */

import java.sql.*;
import tzi.winspect.Main;
import tzi.winspect.Debug.Debug;
import tzi.winspect.Inspector.Inspector;
import tzi.winspect.InvestigateComponent.InvestigateComponentPart;
import tzi.winspect.InvestigateComponent.InvestigateComponent;
import tzi.winspect.InvestigateComponent.SecureViolation;
import tzi.winspect.DataService.ObjectNotFound;
import tzi.winspect.DataService.DataService;
import tzi.winspect.DataService.DataObserver;
import tzi.winspect.Investigation.Finding;
import tzi.winspect.Investigation.Investigation;
import java.util.StringTokenizer;
import java.util.Vector;
import java.io.*;
import java.text.*;

public class DBService implements DataService {
    private final String url = Main.mRB.getString("DB_Server");
    private final String login = Main.mRB.getString("DB_UserName");
    private final String password = Main.mRB.getString("DB_UserPasswd");
    private final String picDir = Main.mRB.getString("Picture_Directory") + "/";
    private Connection mConnection = null;
    private DatabaseMetaData mDatabaseMetaData = null;
    
    public static final int NO_TYPE      = 0;
    public static final int SPEECH_TYPE  = 1;
    public static final int PICTURE_TYPE = 2;
    public static final int VIDEO_TYPE   = 3;
    
    public static final int UNKNOWN                  = 0;
    public static final int ENTRY_ID                 = 1;
    public static final int INVESTIGATE_COMPONENT_ID = 2;
    
    ///////// Constructor zum Aufbau der DBVerbindung ////////////
    
    public DBService(){
        try{
            Class.forName(Main.mRB.getString("jdbcDriver")).newInstance();
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte Datenbanktreiber nicht laden: "+e.toString());
        }
        DriverManager.setLoginTimeout(100);	 //set a timeout for login and query
        try{
            mConnection = DriverManager.getConnection(url,login,password);
        }catch(SQLException e){
            Main.mDebug.print(Debug.ERROR,"Url: " + url + " user: " + login + " passwd: " + password);
            e.printStackTrace();
            Main.mDebug.print(Debug.ERROR,"Konnte nicht am Server anmelden: "+e.toString());
        }
        try{
            mDatabaseMetaData = mConnection.getMetaData();
            if(mDatabaseMetaData.isReadOnly()){
            }else{
            }
            ResultSet mCatalogs = mDatabaseMetaData.getCatalogs();
            while (mCatalogs.next()){
                for(int j=1; j<=mCatalogs.getMetaData().getColumnCount(); j++){
                }
            }
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte Informationen �ber den DBServer nicht ermitteln: "+e.toString());
        }
        try{
            mConnection.setCatalog( "winspect");
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte die Datenbank winspect nicht erreichen: "+e.toString());
        }
        try{
            ResultSet mSchemas = mDatabaseMetaData.getSchemas();
            while (mSchemas.next()){
                for(int j=1; j<=mSchemas.getMetaData().getColumnCount(); j++){
                }
            }
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte keine Tabellen in Winspect auslesen: "+e.toString());
        }
    }
    
    ////////////// getInspectorByID ///////////////////////
    public Inspector getInspectorByID(int inID) throws ObjectNotFound{
        Inspector mReturnObject=new Inspector();
        ResultSet mInspectors=null;
        
        try{
            Statement mSQLStatement= mConnection.createStatement();
            mInspectors = mSQLStatement.executeQuery("SELECT DBID,FirstName,LastName,Feature1,Feature2,Feature3,Feature4,Feature5 from Inspector WHERE DBID= "+inID+" ORDER BY DBID");
            mSQLStatement.close();
            if(mInspectors.next()){
                mReturnObject = new Inspector(mInspectors.getInt(1),mInspectors.getString(2),mInspectors.getString(3),mInspectors.getInt(4),mInspectors.getInt(5),mInspectors.getInt(6),mInspectors.getInt(7),mInspectors.getInt(8));
            }else{
                throw new ObjectNotFound("winspect.DBService","DBService","getInvestigateComponentByTransponderID","No InvestigateComponent found for TransponderID("+inID+")");
            }
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte Component nicht aus der DB auslesen: "+e.toString());
        }
        return mReturnObject;
    }
    
    ////////////// getAllInspectors //////////////////////
    public Vector getAllInspectors(){
        ResultSet mInspectors=null;
        Vector mReturnVector= new Vector();
        
        //Verbinden mit der DB und alle Inspectoren laden
        try{
            Statement mSQLStatement= mConnection.createStatement();
            mInspectors = mSQLStatement.executeQuery("SELECT DBID,FirstName,LastName,Feature1,Feature2,Feature3,Feature4,Feature5 from Inspector ORDER BY LastName");
            mSQLStatement.close();
            while (mInspectors.next()){
                Inspector newInspector=new Inspector(mInspectors.getInt(1),mInspectors.getString(2),mInspectors.getString(3),mInspectors.getInt(4),mInspectors.getInt(5),mInspectors.getInt(6),mInspectors.getInt(7),mInspectors.getInt(8) );
                mReturnVector.add(newInspector);
            }
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte die Inspectoren nicht aus der DB auslesen: "+e.toString());
        }
        return mReturnVector;
    }
    
    ///////// get New DB ID ////////////////
    
    public int getNewDBID(String in){
        ResultSet mInspectors=null;
        int mReturnValue=0;
        
        //Verbinden mit der DB und auslesen der Inspector IDs
        try{
            Statement mSQLStatement= mConnection.createStatement();
            mInspectors = mSQLStatement.executeQuery("SELECT DBID from "+in+" ORDER BY DBID");
            mSQLStatement.close();
            while (mInspectors.next()){
                mReturnValue=mInspectors.getInt(1);
            }
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte die DB nicht auslesen: "+e.toString());
        }
        //mReturnValue um einen Wert erh�hen um n�chste ID zu erhalten
        mReturnValue++;
        return mReturnValue;
    }
    
    //////////////// Get Type Of InfoCode ///////////////////////////////
    
    public int getTypeOfInfoCode(String inID) throws ObjectNotFound{
        ResultSet mResultSet=null;
        
        //Setze Informationen ab
    /*TransferClass tr= new TransferClass();
    tr.setActionType(tr.TRANSPONDER_READ);
    tr.setTransponderID(inID);
    Main.mSocketCommunicatorClient.addTransferObject(tr);*/
        
        try{
            Statement mSQLStatement= mConnection.createStatement();
            mResultSet = mSQLStatement.executeQuery("SELECT DBID from Investigate_Component WHERE TransponderID= '"+inID+"' ORDER BY DBID");
            mSQLStatement.close();
            if(mResultSet.next()){
                return this.INVESTIGATE_COMPONENT_ID;
            }
            mResultSet = mSQLStatement.executeQuery("SELECT DBID from Object_Entry WHERE TransponderID= '"+inID+"' ORDER BY DBID");
            mSQLStatement.close();
            if(mResultSet.next()){
                return this.ENTRY_ID;
            }
            return this.UNKNOWN;
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte die InvestigateComponente nicht finden nicht aus der DB auslesen: "+e.toString());
        }
        return 0;
    }
    
    /**
     * Get All InvestigateParts
     */
    private Vector getAllInvestigateParts(){
        Vector mReturnVector=new Vector();
        ResultSet mResultSet=null;
        
        try{
            Statement mSQLStatement= mConnection.createStatement();
            mResultSet = mSQLStatement.executeQuery("SELECT DBID,InvestigateComponentID,InvestigatePartID,Detail,PossibleResults,InspectionState,InspectionCycleTime,Feature1,Feature2,Feature3,Feature4,Feature5 from Investigate_Component_Part");
            mSQLStatement.close();
            while (mResultSet.next()){
                InvestigateComponentPart mReturnObject = new InvestigateComponentPart();
                try{
                    mReturnObject.setDBID(mResultSet.getInt(1));
                    mReturnObject.setInvestigateComponentID(mResultSet.getInt(2));
                    mReturnObject.setInvestigatePartID(mResultSet.getInt(3));
                    mReturnObject.setDetail(mResultSet.getString(4));
                    StringTokenizer mStringTokenizer= new StringTokenizer(mResultSet.getString(5),",");
                    mReturnObject.setInspectionState(mResultSet.getInt(6));
                    mReturnObject.setInspectionCycleTime(mResultSet.getInt(7));
                    mReturnObject.setFeature(1,mResultSet.getInt(8));
                    mReturnObject.setFeature(2,mResultSet.getInt(9));
                    mReturnObject.setFeature(3,mResultSet.getInt(10));
                    mReturnObject.setFeature(4,mResultSet.getInt(11));
                    mReturnObject.setFeature(5,mResultSet.getInt(12));
                    Vector mIntegerVector = new Vector();
                    while (mStringTokenizer.hasMoreTokens()){
                        mIntegerVector.add(new Integer(mStringTokenizer.nextToken()));
                    }
                    mReturnObject.setPossibleResultsID(mIntegerVector);
                }catch(SecureViolation e){
                    Main.mDebug.print(Debug.ERROR,"Darf nicht auf Object zugreifen!");
                }
                mReturnVector.add(mReturnObject);
            }
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte die Descriptions nicht aus der DB auslesen: "+e.toString());
        }
        mReturnVector.trimToSize();
        return mReturnVector;
    }
    
    /////////////// Get All InvestigateParts By InvestigateComponent ID //////////
    // Liefert alle zugehoerigen Untersuchungen fuer ein zu untersuchendes Object
    
    public Vector getAllInvestigatePartsByInvestigateComponentID(int inID){
        Vector mReturnVector=new Vector();
        ResultSet mResultSet=null;
        
        try{
            Statement mSQLStatement= mConnection.createStatement();
            mResultSet = mSQLStatement.executeQuery("SELECT DBID,InvestigateComponentID,InvestigatePartID,Detail,PossibleResults,InspectionState,InspectionCycleTime,Feature1,Feature2,Feature3,Feature4,Feature5 from Investigate_Component_Part WHERE InvestigateComponentID = "+inID+" ORDER BY DBID");
            mSQLStatement.close();
            while (mResultSet.next()){
                InvestigateComponentPart mReturnObject = new InvestigateComponentPart();
                try{
                    mReturnObject.setDBID(mResultSet.getInt(1));
                    mReturnObject.setInvestigateComponentID(mResultSet.getInt(2));
                    mReturnObject.setInvestigatePartID(mResultSet.getInt(3));
                    mReturnObject.setDetail(mResultSet.getString(4));
                    StringTokenizer mStringTokenizer= new StringTokenizer(mResultSet.getString(5),",");
                    mReturnObject.setInspectionState(mResultSet.getInt(6));
                    mReturnObject.setInspectionCycleTime(mResultSet.getInt(7));
                    mReturnObject.setFeature(1,mResultSet.getInt(8));
                    mReturnObject.setFeature(2,mResultSet.getInt(9));
                    mReturnObject.setFeature(3,mResultSet.getInt(10));
                    mReturnObject.setFeature(4,mResultSet.getInt(11));
                    mReturnObject.setFeature(5,mResultSet.getInt(12));
                    Vector mIntegerVector = new Vector();
                    while (mStringTokenizer.hasMoreTokens()){
                        mIntegerVector.add(new Integer(mStringTokenizer.nextToken()));
                    }
                    mReturnObject.setPossibleResultsID(mIntegerVector);
                }catch(SecureViolation e){
                    Main.mDebug.print(Debug.ERROR,"Darf nicht auf Object zugreifen!");
                }
                mReturnVector.add(mReturnObject);
            }
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte die Descriptions nicht aus der DB auslesen: "+e.toString());
        }
        mReturnVector.trimToSize();
        return mReturnVector;
    }
    
    /////////////// Get Investigate Component By Transponder ID ///////////////
    // Bekommt eine Transponder ID als String und liefert aus ausgefuelltes
    // InvestigateComponent Objekt zurueck
    
    public InvestigateComponent getInvestigateComponentByTransponderID(String inID) throws ObjectNotFound{
        InvestigateComponent mReturnObject=new InvestigateComponent();
        ResultSet mResultSet=null;
        
        //Setze Informationen ab
        //    TransferClass tr= new TransferClass();
        //    tr.setActionType(tr.TRANSPONDER_READ);
        //    tr.setTransponderID(inID);
        //    Main.mSocketCommunicatorClient.addTransferObject(tr);
        
        try{
            Statement mSQLStatement= mConnection.createStatement();
            mResultSet = mSQLStatement.executeQuery("SELECT DBID,TransponderID,ModuleID,ComponentID,ComponentPartID,Crane,Location,PictureURL from Investigate_Component WHERE TransponderID= '"+inID+"' ORDER BY DBID");
            mSQLStatement.close();
            if(mResultSet.next()){
                try{
                    mReturnObject.setDBID(mResultSet.getInt(1));
                    mReturnObject.setTransponderID(mResultSet.getString(2));
                    mReturnObject.setModuleID(mResultSet.getInt(3));
                    mReturnObject.setComponentID(mResultSet.getInt(4));
                    mReturnObject.setComponentPartID(mResultSet.getInt(5));
                    mReturnObject.setCrane(mResultSet.getString(6));
                    mReturnObject.setLocation(mResultSet.getString(7));
                    mReturnObject.setPictureLocation(picDir + mResultSet.getString(8));
                }catch(SecureViolation e){
                    Main.mDebug.print(Debug.ERROR,"Fehler beim Zugriff der set Methoden in der InvestigateComponent Klasse");
                }
            }else{
                throw new ObjectNotFound("winspect.DBServices","DBService","getInvestigateComponentByTransponderID","No InvestigateComponent found for TransponderID("+inID+")");
            }
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte die InvestigateComponente nicht finden nicht aus der DB auslesen: "+e.toString());
        }
        return mReturnObject;
    }
    
    /**
     * Investigate Component By Transonder ID THREAD
     */
    public void getInvestigateComponentByTransponderIDThread(String transponderID, DataObserver dataObserver) {
        GetInvestigateComponentByTransponderIDThread mDBThread = 
            new GetInvestigateComponentByTransponderIDThread(transponderID, dataObserver);
    }
    
    private class GetInvestigateComponentByTransponderIDThread extends Thread {
        String mTransponderID;
        DataObserver dataObserver;
        
        GetInvestigateComponentByTransponderIDThread(String transponderID, DataObserver dataObserver) {
            mTransponderID = transponderID;
            dataObserver = dataObserver;
            this.start();
        }
        
        public void run(){
            try{
                dataObserver.returnInvestigateComponent((Main.mDBService.getInvestigateComponentByTransponderID(mTransponderID)));
            } catch( ObjectNotFound ex ) {
                dataObserver.returnInvestigateComponent( null );
            }
        }
    }
    
    /**
     * Get Maintain Description By ID 
     */
    public Finding getMaintainDescriptionByID(int inID) throws ObjectNotFound{
        Finding mReturnObject=new Finding();
        ResultSet mResultSet=null;
        
        try{
            Statement mSQLStatement= mConnection.createStatement();
            mResultSet = mSQLStatement.executeQuery("SELECT DBID,Description from Maintenance_States WHERE DBID= "+inID+" ORDER BY Description");
            mSQLStatement.close();
            if(mResultSet.next()){
                mReturnObject.setDBID(mResultSet.getInt(1));
                mReturnObject.setDescription(mResultSet.getString(2));
            }else{
                throw new ObjectNotFound("winspect.DBServices","DBService","getInvestigateComponentByTransponderID","No InvestigateComponent found for TransponderID("+inID+")");
            }
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte Module nicht aus der DB auslesen: "+e.toString());
        }
        return mReturnObject;
    }
    
    /**
     * get Module Name By ID 
     */
    public String getModuleNameByID(int inID) throws ObjectNotFound{
        String mReturnObject=new String();
        ResultSet mResultSet=null;
        
        try{
            Statement mSQLStatement= mConnection.createStatement();
            mResultSet = mSQLStatement.executeQuery("SELECT Description from Module WHERE DBID= "+inID+" ORDER BY Description");
            mSQLStatement.close();
            if(mResultSet.next()){
                mReturnObject = mResultSet.getString(1);
            }else{
                throw new ObjectNotFound("winspect.DBServices","DBService","getInvestigateComponentByTransponderID","No InvestigateComponent found for TransponderID("+inID+")");
            }
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte Module nicht aus der DB auslesen: "+e.toString());
        }
        return mReturnObject;
    }
    
    ////////////// get ComponentName By ID /////////////////
    
    public String getComponentNameByID(int inID) throws ObjectNotFound{
        String mReturnObject=new String();
        ResultSet mResultSet=null;
        
        try{
            Statement mSQLStatement= mConnection.createStatement();
            mResultSet = mSQLStatement.executeQuery("SELECT Description from Component WHERE DBID= "+inID+" ORDER BY Description");
            mSQLStatement.close();
            if(mResultSet.next()){
                mReturnObject = mResultSet.getString(1);
            }else{
                throw new ObjectNotFound("winspect.DBServices","DBService","getInvestigateComponentByTransponderID","No InvestigateComponent found for TransponderID("+inID+")");
            }
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte Component nicht aus der DB auslesen: "+e.toString());
        }
        return mReturnObject;
    }
    
    //////////////// add Finding //////////////////////////////////
    
    public void addFinding(InvestigateComponentPart inPart, Finding inFinding){
        int FindingID = this.getNewDBID("Findings");
        java.util.Date today = new java.util.Date();
        
        //////////////// Finding Eintragen in die DB //////////////////////////
        try{
            Statement mSQLStatement= mConnection.createStatement();
            String mRowsString = new String("DBID,InvestigateComponentPartID,MaintainceID,InspectorID,Date");
            String mValueString = new String();
            mValueString += FindingID;
            mValueString += new String(",");
            mValueString += inPart.getDBID();
            mValueString += new String(",");
            mValueString += inFinding.getDBID();
            mValueString += new String(",");
            mValueString += Main.mInspector.getmDBID();
            mValueString += new String(",");
            mValueString += today.getTime();
            int mResult = mSQLStatement.executeUpdate("insert into Findings ("+mRowsString+") values ("+mValueString+")");
            mSQLStatement.close();
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte Component nicht aus der DB auslesen: "+e.toString());
        }
        
        //Inspection State setzen
        updateInspectionState(inPart,4);
        
        //////////////////////////// Setze Informationen ab //////////////////////
        //    TransferClass tr= new TransferClass();
        //    tr.setActionType(tr.FINDING_ADDED);
        //    tr.setFindingID(FindingID);
        //    Main.mSocketCommunicatorClient.addTransferObject(tr);
    }
    
    //////////////////////updateInspectionState ///////////////////////////////
    
    public void updateInspectionState(InvestigateComponentPart inPart, int State){
        int FindingID = this.getNewDBID("Findings");
        
        try{
            Statement mSQLStatement= mConnection.createStatement();
            mSQLStatement.executeUpdate("update Investigate_Component_Part set InspectionState = "+State+" where DBID = "+inPart.getDBID());
            mSQLStatement.close();
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte Component nicht aus der DB auslesen: "+e.toString());
        }
    }
    
    /////////////////////// getAllInvestiagtionsSince() /////////////////////////
    ////////// Liefert alle Untersuchungen fuer einen Part seit
    ////////// einem bestimmten Datum
    /////////////////////////////////////////////////////////////////////////////
    public Vector getAllInvestigationsSince(int PartID, long Date){
        Vector mReturnVector=new Vector();
        ResultSet mResultSet=null;
        
        try{
            Statement mSQLStatement= mConnection.createStatement();
            String queryString = new String();
            queryString += " SELECT DBID,InvestigateComponentPartID,MaintainceID,InspectorID,Date from Findings WHERE ";
            queryString += " InvestigateComponentPartID = "+PartID;
            queryString += " and ";
            queryString += " Date >= "+Date;
            queryString += " ORDER BY DBID";
            mResultSet = mSQLStatement.executeQuery(queryString);
            mSQLStatement.close();
            while (mResultSet.next()){
                Investigation newInvestigation = new Investigation();
                //newInvestigation.setDBID(mResultSet.getInt(1));
                //newInvestigation.setInvestigateComponentPartID(mResultSet.getInt(2));
                //newInvestigation.setFindingID(mResultSet.getInt(3));
                //newInvestigation.setInspectorID(mResultSet.getInt(4));
                //newInvestigation.setDate((long)mResultSet.getInt(5));
                mReturnVector.add(newInvestigation);
            }
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte die Descriptions nicht aus der DB auslesen: "+e.toString());
        }
        mReturnVector.trimToSize();
        return mReturnVector;
    }
    
    ///////////////// getUniqueURLString /////////////////////////////////
    public String getUniqueURLString(int Type){
        //Winspect_TypeID_InspectorID_MillisecondsSince1970
        String returnString = new String();
        
        switch(Type){
            case DBService.NO_TYPE:
                returnString = null;
                break;
            case DBService.SPEECH_TYPE:
                returnString = new String(Main.mRB.getString("captured_Audio_Server")+"\\Winspect_"+Type+"_"+Main.mInspector.getmDBID()+"_"+System.currentTimeMillis()+".wav");
                break;
            case DBService.PICTURE_TYPE:
                returnString = new String(Main.mRB.getString("captured_Image_Server")+"\\Winspect_"+Type+"_"+Main.mInspector.getmDBID()+"_"+System.currentTimeMillis()+".bmp");
                break;
            case DBService.VIDEO_TYPE:
                returnString = new String(Main.mRB.getString("captured_Video_Server")+"\\Winspect_"+Type+"_"+Main.mInspector.getmDBID()+"_"+System.currentTimeMillis()+".avi");
                break;
            default:
                returnString = null;
                break;
        }
        return returnString;
    }
    
    //////////////// add Finding //////////////////////////////////
    public void addMediaFinding(int Type, String URL, InvestigateComponent inComp, InvestigateComponentPart inPart, float Value1, float Value2, float Value3){
        int FindingID = this.getNewDBID("Findings_Media");
        java.util.Date today = new java.util.Date();
        
        try{
            Statement mSQLStatement = mConnection.createStatement();
            String mRowsString  = new String("DBID,MediaType,URL,InspectorID,InvestigateComponentID,InvestigateComponentPartID,Value1,Value2,Value3,Date");
            String mValueString = new String();
            mValueString += FindingID;
            mValueString += new String(",");
            mValueString += Type;
            mValueString += new String(",");
            mValueString += URL;
            mValueString += new String(",");
            mValueString += Main.mInspector.getmDBID();
            mValueString += new String(",");
            mValueString += inComp.getDBID();
            mValueString += new String(",");
            mValueString += inPart.getDBID();
            mValueString += new String(",");
            mValueString += Value1;
            mValueString += new String(",");
            mValueString += Value2;
            mValueString += new String(",");
            mValueString += Value3;
            mValueString += new String(",");
            mValueString += today.getTime();
            int mResult = mSQLStatement.executeUpdate("insert into Findings ("+mRowsString+") values ("+mValueString+")");
            mSQLStatement.close();
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte Component nicht aus der DB auslesen: "+e.toString());
        }
        
        //Setze Informationen ab
        //    TransferClass tr= new TransferClass();
        //    tr.setActionType(tr.FINDING_ADDED);
        //    tr.setFindingID(FindingID);
        //    Main.mSocketCommunicatorClient.addTransferObject(tr);
    }
    
    
    
    //////////////// add Inspector //////////////////////////////////
    
    public void addInspector(String FirstName, String LastName, int Feature1, int Feature2, int Feature3, int Feature4, int Feature5){
        int InspectorID = this.getNewDBID("Inspector");
        
        try{
            Statement mSQLStatement= mConnection.createStatement();
            String mRowsString = new String("DBID,FirstName,LastName,Feature1,Feature2,Feature3,Feature4,Feature5");
            String mValueString = new String();
            mValueString += InspectorID;
            mValueString += new String(",");
            mValueString += new String("'");
            mValueString += FirstName;
            mValueString += new String("'");
            mValueString += new String(",");
            mValueString += new String("'");
            mValueString += LastName;
            mValueString += new String("'");
            mValueString += new String(",");
            mValueString += Feature1;
            mValueString += new String(",");
            mValueString += Feature2;
            mValueString += new String(",");
            mValueString += Feature3;
            mValueString += new String(",");
            mValueString += Feature4;
            mValueString += new String(",");
            mValueString += Feature5;
            int mResult = mSQLStatement.executeUpdate("insert into Inspector ("+mRowsString+") values ("+mValueString+")");
            mSQLStatement.close();
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte Component nicht aus der DB auslesen: "+e.toString());
        }
    }
    
    ///////////////////////// add Componet Part //////////////////////////////////
    
    public void addComponentPart(int InCoID, int InPaID, String Detail, String PossibleResults, int InspectionState, int InspectionCycleTime, int Feature1, int Feature2, int Feature3, int Feature4, int Feature5){
        int InspectorID = this.getNewDBID("investigate_component_part");
        
        try{
            Statement mSQLStatement= mConnection.createStatement();
            String mRowsString = new String("DBID,InvestigateComponentID,InvestigatePartID,Detail,PossibleResults,InspectionState,InspectionCycleTime,Feature1,Feature2,Feature3,Feature4,Feature5");
            String mValueString = new String();
            mValueString += InspectorID;
            mValueString += new String(",");
            mValueString += InCoID;
            mValueString += new String(",");
            mValueString += InPaID;
            mValueString += new String(",");
            mValueString += new String("'");
            mValueString += Detail;
            mValueString += new String("'");
            mValueString += new String(",");
            mValueString += new String("'");
            mValueString += PossibleResults;
            mValueString += new String("'");
            mValueString += new String(",");
            mValueString += InspectionState;
            mValueString += new String(",");
            mValueString += InspectionCycleTime;
            mValueString += new String(",");
            mValueString += Feature1;
            mValueString += new String(",");
            mValueString += Feature2;
            mValueString += new String(",");
            mValueString += Feature3;
            mValueString += new String(",");
            mValueString += Feature4;
            mValueString += new String(",");
            mValueString += Feature5;
            int mResult = mSQLStatement.executeUpdate("insert into investigate_component_part ("+mRowsString+") values ("+mValueString+")");
            mSQLStatement.close();
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte Component nicht aus der DB auslesen: "+e.toString());
        }
    }
    
    ////////////// get ComponentName By ID /////////////////
    
    public String getInspectionStateByID(int inID) throws ObjectNotFound{
        String mReturnObject=new String();
        ResultSet mResultSet=null;
        
        try{
            Statement mSQLStatement= mConnection.createStatement();
            mResultSet = mSQLStatement.executeQuery("SELECT Description from Inspection_States WHERE DBID= "+inID+" ORDER BY Description");
            mSQLStatement.close();
            if(mResultSet.next()){
                mReturnObject = mResultSet.getString(1);
            }else{
                throw new ObjectNotFound("winspect.DBServices","DBService","getInvestigateComponentByTransponderID","No InvestigateComponent found for TransponderID("+inID+")");
            }
        }catch(Exception e){
            Main.mDebug.print(Debug.ERROR,"Konnte Component nicht aus der DB auslesen: "+e.toString());
        }
        return mReturnObject;
    }
    
    public boolean readInspectorsFromFile(String in){
        try{
            System.out.println("Lese aus Datei:"+in);
            File inputFile = new File(in);
            FileReader inReader = new FileReader(inputFile);
            BufferedReader inBuffer = new BufferedReader(inReader);
            String line = inBuffer.readLine();
            System.out.println("Erste Zeile:"+line);
            while(line != null){
                StringTokenizer s= new StringTokenizer(line,"|");
                this.addInspector(s.nextToken(),s.nextToken(),Integer.parseInt(s.nextToken()),Integer.parseInt(s.nextToken()),Integer.parseInt(s.nextToken()),Integer.parseInt(s.nextToken()),Integer.parseInt(s.nextToken()));
                System.out.println(line);
                line = inBuffer.readLine();
            }
        }catch(Exception e){
            e.printStackTrace();
            return false;
        }
        return true;
    }
    
    public boolean readComponetPartFromFile(String in){
        try{
            System.out.println("Lese aus Datei:"+in);
            File inputFile = new File(in);
            FileReader inReader = new FileReader(inputFile);
            BufferedReader inBuffer = new BufferedReader(inReader);
            String line = inBuffer.readLine();
            System.out.println("Erste Zeile:"+line);
            while(line != null){
                StringTokenizer s= new StringTokenizer(line,"|");
                this.addComponentPart(Integer.parseInt(s.nextToken()),Integer.parseInt(s.nextToken()),s.nextToken(),s.nextToken(),Integer.parseInt(s.nextToken()),Integer.parseInt(s.nextToken()),Integer.parseInt(s.nextToken()),Integer.parseInt(s.nextToken()),Integer.parseInt(s.nextToken()),Integer.parseInt(s.nextToken()),Integer.parseInt(s.nextToken()));
                line = inBuffer.readLine();
            }
        }catch(Exception e){
            e.printStackTrace();
            return false;
        }
        return true;
    }
    
    public boolean createTables(){
        //public static ResourceBundle mRB = ResourceBundle.getBundle("tzi.winspect.winspect");
        
        return true;
    }
   
}
