/*
 * DataService.java
 *
 * Created on February 15, 2005, 2:07 PM
 */

package tzi.winspect.DataService;

import java.util.Vector;
import tzi.winspect.Inspector.Inspector;
import tzi.winspect.InvestigateComponent.InvestigateComponentPart;
import tzi.winspect.InvestigateComponent.InvestigateComponent;
import tzi.winspect.InvestigateComponent.SecureViolation;
import tzi.winspect.Investigation.Finding;

/**
 *
 * @version $Revision: 1.3 $
 * @author  jrei
 */
public interface DataService {
    
    public Inspector getInspectorByID(int inID) throws ObjectNotFound;
    
    public Vector getAllInspectors();
    
    public int getTypeOfInfoCode(String inID) throws ObjectNotFound;
    
    public Vector getAllInvestigatePartsByInvestigateComponentID(int inID);
    
    public InvestigateComponent getInvestigateComponentByTransponderID(String inID) throws ObjectNotFound;
    
    public void getInvestigateComponentByTransponderIDThread(String transponderID, DataObserver dataObserver);
    
    public Finding getMaintainDescriptionByID(int inID) throws ObjectNotFound;
    
    public String getModuleNameByID(int inID) throws ObjectNotFound;
    
    public String getComponentNameByID(int inID) throws ObjectNotFound;
    
    public void addFinding(InvestigateComponentPart inPart, Finding inFinding);
    
    public void updateInspectionState(InvestigateComponentPart inPart,int State);
    
    public String getUniqueURLString(int Type);
    
    public void addMediaFinding(int Type, String URL, InvestigateComponent inComp, InvestigateComponentPart inPart, float Value1, float Value2,float Value3);
    
    public void addInspector(String FirstName, String LastName, int Feature1,int Feature2,int Feature3,int Feature4,int Feature5);
    
    public void addComponentPart(int InCoID,int InPaID, String Detail, String PossibleResults, int InspectionState,int InspectionCycleTime ,int Feature1,int Feature2,int Feature3,int Feature4,int Feature5);
    
    public String getInspectionStateByID(int inID) throws ObjectNotFound;
    
}

/*
 * $Log: DataService.java,v $
 * Revision 1.3  2005/03/03 13:56:43  jrei
 * xml config running
 *
 * Revision 1.2  2005/02/27 20:18:00  jrei
 * restructuring for xml service\nfirst tests
 *
 * Revision 1.1  2005/02/17 15:39:23  jrei
 * not finished version of the data service. More to come, before integration in the working system.
 *
 */
