/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.winspect.Debug;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class Debug 
{
    public static final int NO_DEBUG = 0;
    public static final int WRITE_ERROR_TO_SCREEN = 1;
    public static final int WRITE_ERROR_TO_DISK = 2;
    public static final int WRITE_DEBUG_TO_SCREEN = 3;
    public static final int WRITE_DEBUG_TO_DISK = 4;
    public static final int WRITE_TRACE_TO_SCREEN = 5;
    public static final int WRITE_TRACE_TO_DISK = 6;
    public static final int WRITE_INFO_TO_SCREEN = 7;
    public static final int WRITE_INFO_TO_DISK = 8;
    public static final int WRITE_NOTICE_TO_SCREEN = 9;
    public static final int WRITE_NOTICE_TO_DISK = 10;
    public static final int MAX_DEBUG_TO_SCREEN = 11;
    public static final int MAX_DEBUG_TO_DISK = 12;
    public static final int ERROR = 0;
    public static final int DEBUG = 1;
    public static final int TRACE = 2;
    public static final int INFO = 3;
    public static final int NOTICE = 4;
    private int mDebugValue = 0;
    private FileWriter mFile = null;
   
    /**
       @roseuid 397FFA4001FC
    */
    public Debug(int inDebugValue, String inPath) 
    {
	if(inDebugValue<0 || inDebugValue>MAX_DEBUG_TO_DISK){
	    //ERROR
	}else{
	    mDebugValue=inDebugValue;
	    if(inPath!=null){
		try{
		    mFile=new FileWriter(inPath,true);
		    mFile.flush();
		}catch (IOException e){
		}
	    }
	}
    }
   
    /**
       @roseuid 397FFA400206
    */
    public void print(int inTypeOf, String inDebugString) 
    {
	switch(mDebugValue){
	case NO_DEBUG:
	    // Keine Ausgabe von Informationen
	    break;
	case WRITE_ERROR_TO_SCREEN:
	    // Nur Fehlermeldungen auf den Screen bringen
	    if(inTypeOf<=ERROR){
		System.out.println(new Date().toString()+":("+inTypeOf+")"+inDebugString);
	    }
	    break;
	case WRITE_ERROR_TO_DISK:
	    // Nur Fehlermeldungen ins File schreiben
	    if(inTypeOf<=ERROR){
		try{
		    mFile.write(new Date().toString()+":("+inTypeOf+")"+inDebugString+"\n");
		    mFile.flush();
		}catch (IOException e){
		}
	    }
	    break;
	case WRITE_DEBUG_TO_SCREEN:
	    // DEBUG und Fehlermeldungen schreiben
	    if(inTypeOf<=DEBUG){
		System.out.println(new Date().toString()+":("+inTypeOf+")"+inDebugString);
	    }
	    break;
	case WRITE_DEBUG_TO_DISK:
	    // DEBUG und Fehlermeldungen schreiben
	    if(inTypeOf<=DEBUG){
		try{
		    mFile.write(new Date().toString()+":("+inTypeOf+")"+inDebugString+"\n");
		    mFile.flush();
		}catch(IOException e){
		}
	    }
	    break;
	case WRITE_TRACE_TO_SCREEN:
	    // TRACE,Debug und Fehlermeldungen schreiben
	    if(inTypeOf<=TRACE){
		System.out.println(new Date().toString()+":("+inTypeOf+")"+inDebugString);
	    }
	    break;
	case WRITE_TRACE_TO_DISK:
	    // TRACE,Debug und Fehlermeldungen schreiben
	    if(inTypeOf<=TRACE){
		try{
		    mFile.write(new Date().toString()+":("+inTypeOf+")"+inDebugString+"\n");
		    mFile.flush();
		}catch(IOException e){
		}
	    }
	    break;
	case WRITE_INFO_TO_SCREEN:
	    // INFO, Trace, Debug und Fehlermeldungen schreiben
	    if(inTypeOf<=INFO){
		System.out.println(new Date().toString()+":("+inTypeOf+")"+inDebugString);
	    }
	    break;
	case WRITE_INFO_TO_DISK:
	    // INFO, Trace, Debug und Fehlermeldungen schreiben
	    if(inTypeOf<=INFO){
		try{
		    mFile.write(new Date().toString()+":("+inTypeOf+")"+inDebugString+"\n");
		    mFile.flush();
		}catch(IOException e){
		}
	    }
	    break;
	case WRITE_NOTICE_TO_SCREEN:
	    // NOTICE, Info, Trace, Debug und Fehlermeldungen schreiben
	    if(inTypeOf<=NOTICE){
		System.out.println(new Date().toString()+":("+inTypeOf+")"+inDebugString);
	    }
	    break;
	case WRITE_NOTICE_TO_DISK:
	    // NOTICE, Info, Trace, Debug und Fehlermeldungen schreiben
	    if(inTypeOf<=NOTICE){
		try{
		    mFile.write(new Date().toString()+":("+inTypeOf+")"+inDebugString+"\n");
		    mFile.flush();
		}catch(IOException e){
		}
	    }
	    break;
	case MAX_DEBUG_TO_SCREEN:
	    // ALLES Schreiben
	    System.out.println(new Date().toString()+":("+inTypeOf+")"+inDebugString);
	    break;
	case MAX_DEBUG_TO_DISK:
	    // ALLES Schreiben
	    try{
		mFile.write(new Date().toString()+":("+inTypeOf+")"+inDebugString+"\n");
		mFile.flush();
	    }catch(IOException e){
	    }
	    break;
	default:
	    //
	    break;
	}
    }
}
