/**
 * �berschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.winspect.Inspector;

import tzi.winspect.Main;
import tzi.winspect.Debug.Debug;
import tzi.winspect.DBServices.DBService;

public class Inspector{
    private int mDBID            = -1;
    // jrei: not used private boolean mIsAllowedTo = false;
    private String mFirstName    = new String();
    private String mLastName     = new String();
    private int[] mFeature       = new int[5];
    
    public boolean setFeature(int f1,int f2,int f3,int f4,int f5){
        mFeature[0] = f1;
        mFeature[1] = f2;
        mFeature[2] = f3;
        mFeature[3] = f4;
        mFeature[4] = f5;
        return true;
    }
    
    public boolean setFeature(int index,int value){
        if(index>0 && index <6){
            mFeature[index-1]=value;
            return true;
        }else{
            return false;
        }
    }
    
    /** Sets the dataset ID (DataBaseID). 
     * @return true, if set successfully, false if the inspector 
     *  allready has a dataset ID.
     */
    public boolean setDataSetID(int dataSetID){
        if (this.mDBID != -1){
            this.mDBID = dataSetID;
            return true;
        }
        return false;
    }
    
    public int[] getAllFeatures(){
        return mFeature;
    }
    
    public int getFeature(int index){
        if(index>0 && index <6){
            return mFeature[index -1];
        }else{
            return -1;
        }
    }
    
    public int getmDBID(){
        return mDBID;
    }
    
    public String getFirstName(){
        return mFirstName;
    }
    
    public boolean setFirstName(String inFirstName){
        mFirstName=inFirstName;
        Main.mDebug.print(Debug.INFO,"FirstName auf "+inFirstName+" gesetzt.");
        return true;
    }
    
    public String getLastName(){
        return mLastName;
    }
    
    public boolean setLastName(String inLastName){
        mLastName=inLastName;
        Main.mDebug.print(Debug.INFO,"LastName auf "+inLastName+" gesetzt.");
        return true;
    }
    
    public Inspector(){
        Main.mDebug.print(Debug.TRACE,"Neue Klasse von Typ Inspector angelegt");
    }
    
    /**
     * Creates a new Inspector Object.
     * @param inDBID The DataSetID
     * @param inFirstName The first name
     * @param inLastName the Family name
     * @param f1 feature 1
     * @param f2 feature 2
     * @param f3 feature 3
     * @param f4 feature 4
     * @param f5 feature 5
     */
    public Inspector(int inDBID, String inFirstName, String inLastName,int f1,int f2,int f3,int f4,int f5){
        mDBID=inDBID;
        mFirstName=inFirstName;
        mLastName=inLastName;
        mFeature[0] = f1;
        mFeature[1] = f2;
        mFeature[2] = f3;
        mFeature[3] = f4;
        mFeature[4] = f5;
    }
    
    public String toString(){
        if (this.getmDBID()==-1){
            return "    ";
        }else{
            return this.getLastName()+", "+this.getFirstName();
        }
    }
}
