/**
 * �berschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.winspect.InvestigateComponent;

import java.util.Vector;
import tzi.winspect.Main;
import tzi.winspect.DataService.ObjectNotFound;
import java.net.URL;
import java.net.MalformedURLException;


public class InvestigateComponent{
    private int mDBID = 0;
    private String mTransponderID = new String();
    private int mModuleID = 0; //Baugruppe (Hubwerk 55 t)
    private String mModuleName = new String();
    private int mComponentID = 0; //Bauteil (Motor)
    private String mComponentName = new String();
    private int mComponentPartID = 0; //Laufende Nummer (1,2 Motor)
    private Vector mInvestigateParts = null; //Vector mit Objekten von InvestigateParts
    private String mCrane = new String(); //Der Kranname (Kran 29)
    private String mLocation = new String(); //Welcher Ort (VEG,HB)
    private String mPictureLocation = new String(); //Werbeprospekt zur Kontrolle des Transponders
    
    public InvestigateComponent(){
    }
    
    /////////// DB ///////////////////////
    
    public boolean setDBID(int in) throws SecureViolation{
        if (true){
            mDBID = in;
            mInvestigateParts = Main.mDBService.getAllInvestigatePartsByInvestigateComponentID(this.mDBID);
            return true;
        }else{
            throw new SecureViolation("winspect.InvestigateComponent","InvestigateComponent","setDBIDID","Not allowed to edit value");
        }
    }
    
    public int getDBID(){
        return mDBID;
    }
    
    /////////// TransponderID /////////////////
    
    public boolean setTransponderID(String in) throws SecureViolation{
        if(true){ /*TODO:Sicherheits�berpr�fung*/
            mTransponderID=in;
            return true;
        }else{
            throw new SecureViolation("winspect.InvestigateComponent","InvestigateComponent","setTransponderID","Not allowed to edit value");
        }
    }
    
    public String getTransponderID(){
        return mTransponderID;
    }
    
    ///////// Module ///////////////////////
    
    public boolean setModuleID(int in) throws SecureViolation{
        if(true){ /*TODO:Sicherheits�berpr�fung*/
            mModuleID=in;
            try{
                mModuleName = Main.mDBService.getModuleNameByID(this.mModuleID);
            }catch(ObjectNotFound e){
            }
            return true;
        }else{
            throw new SecureViolation("winspect.InvestigateComponent","InvestigateComponent","setModuleID","Not allowed to edit value");
        }
    }
    
    public int getModule(){
        return mModuleID;
    }
    
    public String getModuleName() throws ObjectNotFound{
        return this.mModuleName;
    }
    
    ////////////// Component ///////////////////////
    
    public boolean setComponentID(int in) throws SecureViolation{
        if(true){ /*TODO:Sicherheits�berpr�fung*/
            mComponentID=in;
            try{
                mComponentName = Main.mDBService.getComponentNameByID(this.mComponentID);
            }catch(ObjectNotFound e){
            }
            return true;
        }else{
            throw new SecureViolation("winspect.InvestigateComponent","InvestigateComponent","setComponentID","Not allowed to edit value");
        }
    }
    
    public int getComponentID(){
        return mComponentID;
    }
    
    public String getComponentName() throws ObjectNotFound{
        return this.mComponentName;
    }
    
    /** Sets the Component Name/Description.
     * @param String componentName The description of the Component.
     */
    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    ////////////// Component Part /////////////////
    
    public boolean setComponentPartID(int in) throws SecureViolation{
        if(true){ /*TODO:Sicherheits�berpr�fung*/
            mComponentPartID=in;
            return true;
        }else{
            throw new SecureViolation("winspect.InvestigateComponent","InvestigateComponent","setComponentPartID","Not allowed to edit value");
        }
    }
    
    public int getComponentPartID(){
        return mComponentPartID;
    }
    
    ////////////// Investigate Parts //////////////////////
    
    public Vector getInvestigateParts(){
        return this.mInvestigateParts;
    }
    
    /////////////// Crane //////////////////////////
    
    public boolean setCrane(String in) throws SecureViolation{
        if(true){ /*TODO:Sicherheits�berpr�fung*/
            mCrane=in;
            return true;
        }else{
            throw new SecureViolation("winspect.InvestigateComponent","InvestigateComponent","setCrane","Not allowed to edit value");
        }
    }
    
    public String getCrane(){
        return mCrane;
    }
    
    //////////// Location ////////////////////
    
    public boolean setLocation(String in) throws SecureViolation{
        if(true){ /*TODO:Sicherheits�berpr�fung*/
            mLocation=in;
            return true;
        }else{
            throw new SecureViolation("winspect.InvestigateComponent","InvestigateComponent","setTransponderID","Not allowed to edit value");
        }
    }
    
    public String getLocation(){
        return mLocation;
    }
    
    ////////////// Picture Location ///////////////////
    
    public boolean setPictureLocation(String in) throws SecureViolation{
        if(true){ /*TODO:Sicherheits�berpr�fung*/
            mPictureLocation=in;
            return true;
        }else{
            throw new SecureViolation("winspect.InvestigateComponent","InvestigateComponent","setPictureURL","Not allowed to edit value");
        }
    }
    
    public String getPictureLocation(){
        return mPictureLocation;
    }
    
    /////////// to String /////////////////
    
    public String toString(){
        try{
            return this.getComponentName();
        }catch(ObjectNotFound e){
            return "";
        }
    }
}
