/**
 * �berschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.winspect.InvestigateComponent;

import tzi.winspect.Main;
import java.util.Vector;
import tzi.winspect.DataService.ObjectNotFound;
import tzi.winspect.Investigation.Finding;


public class InvestigateComponentPart {
    private int mDBID = 0;
    private int mInvestigateComponentID = 0;
    private int mInvestigatePartID = 0; //Laufende Nummer Untersuchung (Komplett usw.)
    private String mDetail = new String(); //Textuelle Beschreibung der Teiluntersuchung
    private Vector mPossibleResultsID = null; //Moegliche Bewertungen als ID
    private int mInspectionState =0; //Status der Bewertung (Muss mal wieder...)
    private int mInspectionCycleTime = 0;
    private int[] mFeature       = new int[5];
    
    ////////////////// Cylcle Time ///////////////////////
    public boolean setInspectionCycleTime(int in){
        mInspectionCycleTime = in;
        return true;
    }
    
    public int getInspectionCycleTime(){
        return mInspectionCycleTime;
    }
    
    ///////////////// Features /////////////////////////
    
    public boolean setFeature(int f1,int f2,int f3,int f4,int f5){
        mFeature[0] = f1;
        mFeature[1] = f2;
        mFeature[2] = f3;
        mFeature[3] = f4;
        mFeature[4] = f5;
        return true;
    }
    
    public boolean setFeature(int index,int value){
        if(index>0 && index <6){
            mFeature[index-1]=value;
            return true;
        }else{
            return false;
        }
    }
    
    public int[] getAllFeatures(){
        return mFeature;
    }
    
    public int getFeature(int index){
        if(index>0 && index <6){
            return mFeature[index -1];
        }else{
            return -1;
        }
    }
    
    //////////////// DBID ////////////////
    
    public boolean setDBID(int in) throws SecureViolation{
        if(true){ /*TODO:Sicherheits�berpr�fung*/
            mDBID=in;
            return true;
        }else{
            throw new SecureViolation("winspect.InvestigateComponent","InvestigateComponentPart","setDBID","Not allowed to edit value");
        }
    }
    
    public int getDBID(){
        return mDBID;
    }
    
    ////////////////// Investigate Component //////////////////////////
    
    public boolean setInvestigateComponentID(int in) throws SecureViolation{
        if(true){ /*TODO:Sicherheits�berpr�fung*/
            mInvestigateComponentID=in;
            return true;
        }else{
            throw new SecureViolation("winspect.InvestigateComponent","InvestigateComponentPart","setInvestigateComponentPartID","Not allowed to edit value");
        }
    }
    
    public int getInvestigateComponentID(){
        return mInvestigatePartID;
    }
    
    ///////////////// Investigate Part //////////////////////
    
    public boolean setInvestigatePartID(int in) throws SecureViolation{
        if(true){ /*TODO:Sicherheits�berpr�fung*/
            mInvestigatePartID=in;
            return true;
        }else{
            throw new SecureViolation("winspect.InvestigateComponent","InvestigateComponentPart","setInvestigatePartID","Not allowed to edit value");
        }
    }
    
    public int getInvestigatePartID(){
        return mInvestigatePartID;
    }
    
    ///////////////// Detail /////////////////////////
    
    public boolean setDetail(String in) throws SecureViolation{
        if(true){ /*TODO:Sicherheits�berpr�fung*/
            mDetail=in;
            return true;
        }else{
            throw new SecureViolation("winspect.InvestigateComponent","InvestigateComponentPart","setDetail","Not allowed to edit value");
        }
    }
    
    public String getDetail(){
        return mDetail;
    }
    
    ///////////////////// Possible Results ///////////////////////
    
    public boolean setPossibleResultsID(Vector in) throws SecureViolation{
        if(true){ /*TODO:Sicherheits�berpr�fung*/
            mPossibleResultsID=in;
            return true;
        }else{
            throw new SecureViolation("winspect.InvestigateComponent","InvestigateComponentPart","setInvestigatePartID","Not allowed to edit value");
        }
    }
    
    public Vector getPossibleResultsID(){
        return mPossibleResultsID;
    }
    
    ////////////////////// Possible Findings ///////////////////
    
    public Vector getPossibleFindings() throws ObjectNotFound{
        Vector mReturnVector = new Vector();
        for(int i=0;i<this.mPossibleResultsID.size();i++){
            Integer mInt = (Integer) mPossibleResultsID.elementAt(i);
            mReturnVector.add(Main.mDBService.getMaintainDescriptionByID(mInt.intValue()));
        }
        return mReturnVector;
    }
    
    //////////// add Finding //////////////////////////////////
    
    public boolean addFinding(Finding in){
        System.out.println("Finding abgegeben"+in);
        Main.mDBService.addFinding(this,in);
        return true;
    }
    
    ///////////// InspectionState ///////////////////////////////
    
    public void setInspectionState(int in){
        mInspectionState =in;
    }
    
    public int getInspectionStateID(){
        return mInspectionState;
    }
    
    //////// to String ////////////////////////////////////////
    
    public String toString(){
        return mDetail;
    }
    
}