
/**
 * �berschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */

///// Stellt eine Untersuchung dar, welche aus einer DB ausgelesen wurde.


package tzi.winspect.Investigation;

import java.util.Vector;
import java.util.Date;
import tzi.winspect.Main;
import tzi.winspect.Inspector.*;
import tzi.winspect.InvestigateComponent.*;
import tzi.winspect.DataService.*;
//import tzi.winspect.DBServices.*;

public class Investigation{
    private int mDBID                       = 0;
    private java.util.Date mDate            = null;
    private int mInvestigateComponentID     = 0;
    private int mInvestigateComponentPartID = 0;
    private int mInspectorID                = 0;
    private int mFindingID                  = 0;
    
    public Investigation(){
    }
    
    public void setDBID(int in){
        mDBID=in;
    }
    
    public int getDBID(){
        return mDBID;
    }
    
    public void setDate(Date in){
        mDate=in;
    }
    
    public void setDate(long in){
        mDate= new Date((long)in);
    }
    
    public Date getDate(){
        return mDate;
    }
    
    public long getDateAsLong(){
        return mDate.getTime();
    }
    
    public String getDateAsString(){
        return mDate.toString();
    }
    
    public void setInvestigateComponentID(int in){
        mInvestigateComponentID=in;
    }
    
    public int getInvestigateComponentID(){
        return mInvestigateComponentID;
    }
    
    public void setInvestigateComponentPartID(int in){
        mInvestigateComponentPartID=in;
    }
    
    public int getInvestigateComponentPartID(){
        return mInvestigateComponentPartID;
    }
    
    public void setInspectorID(int in){
        mInspectorID=in;
    }
    
    public int getInspectorID(){
        return mInspectorID;
    }
    
    public Inspector getInspector(){
        try{
            return Main.mDBService.getInspectorByID(mInspectorID);
        }catch(ObjectNotFound e){
            return null;
        }
    }
    
    public void setFindingID(int in){
        mFindingID=in;
    }
    
    public int getFindingID(){
        return mFindingID;
    }
    
    public Finding getFinding(){
        try{
            return Main.mDBService.getMaintainDescriptionByID(mFindingID);
        }catch(ObjectNotFound e){
            return null;
        }
    }
    
}
