package tzi.winspect;

/**
 * Winspect Hauptklasse
 * @author Zuletzt bearbeitet von $Author: jrei $
 * @version $Revision: 1.9 $ $Date: 2005/03/04 14:16:43 $
 */

import tzi.winspect.Debug.Debug;
import tzi.winspect.DataService.DataService;
import tzi.winspect.DataService.XMLService;
import tzi.winspect.DBServices.DBService;
import tzi.winspect.Inspector.Inspector;
import tzi.winspect.UserInterface.*;
import javax.swing.*;
import tzi.UserInput.*;
import tzi.WearableInterface.*;
import java.util.ResourceBundle;

public class Main{
    
    public static ResourceBundle mRB = ResourceBundle.getBundle("tzi.winspect.winspect");
    public static Debug mDebug = new Debug (Debug.NO_DEBUG, mRB.getString("logfile"));
    //public static Debug mDebug = new Debug(Debug.MAX_DEBUG_TO_SCREEN, mRB.getString("logfile"));
    //public static DataService mDBService = new DBService ();
    /* TODO: Systemvariable WINSPECT_ROOT wird geändert. */
    public static DataService mDBService =
        new XMLService(mRB.getString("Root_Dir") + "/../../winspect.xml");
    public static Inspector mInspector = new Inspector();
    
    public Main() {
        // Hauptfenster starten
        JFrame frame = new JFrame( "Winspect" );
        frame.pack();
        frame.show();
        frame.requestFocus();
        
        MainFrame mainFrame = new MainFrame( frame );
        mainFrame.setVisible( true );
        mainFrame.pack();
        mainFrame.show();
        
        InputCenter mInputCenter = InputCenter.getInstance();
    }
    
    public static void main(String[] args) {
        Main main1 = new Main();
    }
}
