
/**
 * �berschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.winspect.UserInterface;

//import tzi.winspect.DBServices.*;
import tzi.winspect.DataService.*;
import tzi.winspect.InvestigateComponent.*;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import tzi.WearableInterface.*;

public class ComponentInfoPanel extends JPanel {

  private JLabel      mCraneLabel;
  private JLabel      mLocationLabel;
  private JLabel      mComponentLabel;
  private JLabel      mModuleLabel;
  private JPanel      mLabelPanel;

  private JLabel      mCraneValue;
  private JLabel      mLocationValue;
  private JLabel      mComponentValue;
  private JLabel      mModuleValue;
  private JPanel      mValuePanel;

  private ImageIcon   mPic;
  private JLabel      mPicLabel;


  public ComponentInfoPanel( InvestigateComponent ic )
  {
    try {
      mCraneLabel = new JLabel( "               Kran: " );
      mCraneLabel.setFont( Toolbox.getFont() );
      mCraneLabel.setForeground( Toolbox.getFontColor() );
      mLocationLabel = new JLabel( "               Ort: " );
      mLocationLabel.setFont( Toolbox.getFont() );
      mLocationLabel.setForeground( Toolbox.getFontColor() );
      mModuleLabel = new JLabel( "               BG: " );
      mModuleLabel.setFont( Toolbox.getFont() );
      mModuleLabel.setForeground( Toolbox.getFontColor() );
      mComponentLabel = new JLabel( "               BT: " );
      mComponentLabel.setFont( Toolbox.getFont() );
      mComponentLabel.setForeground( Toolbox.getFontColor() );

      mLabelPanel = new JPanel();
      mLabelPanel.setBackground(Toolbox.getBackground());
      mLabelPanel.setLayout( new BoxLayout( mLabelPanel, BoxLayout.Y_AXIS ) );
      mLabelPanel.add( mCraneLabel );
      mLabelPanel.add( mLocationLabel );
      mLabelPanel.add( mModuleLabel );
      mLabelPanel.add( mComponentLabel );

      mCraneValue = new JLabel( ic.getCrane() );
      mCraneValue.setFont( Toolbox.getFont() );
      mCraneValue.setForeground( Toolbox.getFontColor() );
      mLocationValue = new JLabel( ic.getLocation() );
      mLocationValue.setFont( Toolbox.getFont() );
      mLocationValue.setForeground( Toolbox.getFontColor() );
      mModuleValue = new JLabel( ic.getModuleName() );
      mModuleValue.setFont( Toolbox.getFont() );
      mModuleValue.setForeground( Toolbox.getFontColor() );
      mComponentValue = new JLabel( ic.getComponentName() );
      mComponentValue.setFont( Toolbox.getFont() );
      mComponentValue.setForeground( Toolbox.getFontColor() );

      mValuePanel = new JPanel();
      mValuePanel.setBackground(Toolbox.getBackground());
      mValuePanel.setLayout( new BoxLayout( mValuePanel, BoxLayout.Y_AXIS ) );
      mValuePanel.add( mCraneValue );
      mValuePanel.add( mLocationValue );
      mValuePanel.add( mModuleValue );
      mValuePanel.add( mComponentValue );

      mPic = new ImageIcon( ic.getPictureLocation() );
      if( mPic.getImage().getHeight( null ) > mPic.getImage().getWidth( null ) )
        mPicLabel = new JLabel( new ImageIcon( mPic.getImage().getScaledInstance( -1, 80, Image.SCALE_SMOOTH ) ) );
      else
        mPicLabel = new JLabel( new ImageIcon( mPic.getImage().getScaledInstance( 80, -1, Image.SCALE_SMOOTH ) ) );

      add( mLabelPanel );
      add( mValuePanel );
      add( mPicLabel );

      setBackground(Toolbox.getBackground());

    } catch( Exception e ) {
      e.printStackTrace();
    } catch( ObjectNotFound e ) {
    }

  }

  /*
  public Dimension getPreferredSize()
  {
    return new Dimension( 150, 110 );
  }
  */
}
