package tzi.winspect.UserInterface;

import tzi.WearableInterface.*;
import javax.swing.*;


public class ContextMenu extends WIPanel implements SelectorListEventListener {

  private WIPanel mParent;
  private final int MENU_ABBRUCH = 1;
  private SelectorList mList;
  private MenuEntry mContextEntry;
  private JLabel mHeadLabel;
  private JLabel mInfoLabel;

  public ContextMenu( WIPanel parent, MenuVector menu )
  {
    super();

    mParent = parent;

    try {
      mHeadLabel = new JLabel( "Kontextmenue" );
      mHeadLabel.setFont( Toolbox.getFont() );
      mInfoLabel = new JLabel( "..." );
      mInfoLabel.setFont( Toolbox.getFont() );

      menu.add( this, new String( "Menue schliessen" ), MENU_ABBRUCH, Toolbox.getIcon(Toolbox.ICON_CANCEL30), Toolbox.getIcon(Toolbox.ICON_CANCEL30) );
      mList = new SelectorList( menu );
      mList.addSelectorListEventListener( this );
      mList.connect();

      setBorder( BorderFactory.createEmptyBorder( 100, 100, 100, 100 ) );
      setLayout( new BoxLayout( this, BoxLayout.Y_AXIS ) );
      add( mHeadLabel );
      //add( mInfoLabel );
      add( mList );
    }
    catch(Exception ex) {
      ex.printStackTrace();
    }

    InputCenter.getInstance().requestFocus( mList );
  }

  public MenuEntry getSelectedContextEntry()
  {
    return mContextEntry;
  }

  // WIPanel Interface //
  public void onCloseChild( WIPanel child )
  {
  }

  public MenuVector getContextMenu()
  {
    return null;
  }

  public void dispatchContextCommand( MenuEntry e )
  {
  }

  public void close()
  {
    mList.disconnect();
  }

  public void saveFocus()
  {
  }

  public void restoreFocus()
  {
  }

  // SelectorListEventListener Interface //
  public void selection( SelectorListEvent evt )
  {
    MenuEntry entry = evt.getMenuEntry();

    if( entry.getSource()==this ) {

      switch( entry.getID() ) {
      case MENU_ABBRUCH:
        mContextEntry = null;
        break;
      }

    } else {
      mContextEntry = entry;
    }

    mParent.onCloseChild( this );
  }

}
