/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.winspect.UserInterface;

import tzi.winspect.*;
import javax.swing.*;
import javax.swing.border.*;
import java.util.*;
import java.text.*;
import java.awt.*;
import tzi.WearableInterface.*;

public class GlobalinfoPanel extends JPanel {

    private JLabel        mInspectorLabel;
    private JLabel        mTimeLabel;
    private MyTimer       mTimer;

    public GlobalinfoPanel()
    {
	super();

	try {
	    mInspectorLabel = new JLabel( "" );
	    mInspectorLabel.setFont( Toolbox.getFont() );
	    mInspectorLabel.setForeground( Toolbox.getFontColor() );

	    mTimeLabel = new JLabel( "" );
	    mTimeLabel.setFont( Toolbox.getFont() );
	    mTimeLabel.setForeground( Toolbox.getFontColor() );

	    setLayout( new BorderLayout() );
	    add( mInspectorLabel, BorderLayout.WEST );
	    add( mTimeLabel, BorderLayout.EAST );

	    setBackground(Toolbox.getBackground());

	} catch( Exception e ) {
	    e.printStackTrace();
	}

	clockTick();

	mTimer = new MyTimer();
	mTimer.setPriority( Thread.MIN_PRIORITY );
	mTimer.start();
    }

    private void clockTick()
    {
	Date date = new Date();
	mTimeLabel.setText(DateFormat.getDateTimeInstance().format(date));

	if( Main.mInspector != null )
	    mInspectorLabel.setText( "Inspektor: "+Main.mInspector.toString() );
	else
	    mInspectorLabel.setText( "" );
    }

    private class MyTimer extends Thread {

	MyTimer() {
	}

	public void run(){
	    while(true){
		try{
		    sleep( 1000 );
		    clockTick();
		} catch (InterruptedException ex){}
	    }
	}

    }
}
