/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.winspect.UserInterface;

import tzi.winspect.*;
import tzi.winspect.InvestigateComponent.*;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.util.*;
import tzi.WearableInterface.*;
import tzi.winspect.InvestigateComponent.ChiefJudge;
import tzi.winspect.Main;

public class InvestigateComponentPanel extends WIPanel implements SelectorListEventListener {

    private final int                       PART = 0;
    private final int                       CANCEL = 1;

    private InvestigateComponent            mInvestigateComponent;
    private Vector                          mParts;
    private boolean[]                       mPartChecked;
    private int                             mCheckPartIndex;
  
    private JPanel                          mPartMenuPanel;
    private JLabel                          mPartHeading;
    private SelectorList                    mPartList;
    private ComponentInfoPanel              mInfoPanel;
    private InvestigateComponentPartPanel   mPartPanel;
    private WIPanel                         mParent;
    private JPanel                          mNorthPanel;
    private MenuVector                      mMenuEntries;
    private int                             mFocusPosition;

    public InvestigateComponentPanel( WIPanel parent, InvestigateComponent ic )
    {
	super();

	mParent = parent;
	mInvestigateComponent = ic;
	mParts = ic.getInvestigateParts();
	mPartChecked = new boolean[mParts.size()];
	for( int i=0; i<mParts.size(); i++ )
	    mPartChecked[i] = false;
	fillMenu();

	try {

	    setBackground(Toolbox.getBackground());

	    mPartList = new SelectorList( mMenuEntries );
	    mPartList.addSelectorListEventListener( this );
	    mPartList.connect();
	    InputCenter.getInstance().requestFocus( mPartList );

	    mPartMenuPanel = new JPanel();
	    mPartMenuPanel.setBackground(Toolbox.getBackground());
	    mPartMenuPanel.setLayout( new BorderLayout() );
	    mPartMenuPanel.add( mPartList, BorderLayout.CENTER );

	    //JPanel spacepanel = new JPanel();
	    //spacepanel.setPreferredSize( new Dimension( 500, 10 ) );
	    //mPartMenuPanel.add( spacepanel, BorderLayout.EAST );

	    mInfoPanel = new ComponentInfoPanel( ic );

	    mNorthPanel = new JPanel();
	    mNorthPanel.setBackground(Toolbox.getBackground());
	    mNorthPanel.add( mPartMenuPanel );
	    mNorthPanel.add( mInfoPanel );

	    setBorder( Toolbox.getBorder() );
	    setLayout( new BorderLayout() );
	    add( mNorthPanel, BorderLayout.NORTH );

	} catch( Exception e ) {
	    e.printStackTrace();
	}
    }

    private void fillMenuNoCheck( int id, ImageIcon icon )
    {
	for( int i=0; i<mParts.size(); i++ ) {
	    if( !mPartChecked[i] && (ChiefJudge.getDecision( Main.mInspector, (InvestigateComponentPart)mParts.get(i) )==id) ) {
		mMenuEntries.add( this, mParts.get(i), PART, icon, icon );
	    }
	}
    }

    private void fillMenuCheck()
    {
	for( int i=0; i<mParts.size(); i++ ) {
	    if( mPartChecked[i] || (ChiefJudge.getDecision( Main.mInspector, (InvestigateComponentPart)mParts.get(i) )==ChiefJudge.FERTIG) ) {
		mMenuEntries.add( this, mParts.get(i), PART, Toolbox.getIcon( Toolbox.ICON_CHECKOK30 ), Toolbox.getIcon( Toolbox.ICON_CHECKOK30 ) );
	    }
	}
    }

    private void fillMenu()
    {
	int     i;

	mMenuEntries = new MenuVector();

	// Kritische Teile zuerst
	fillMenuNoCheck( ChiefJudge.KRITISCH, Toolbox.getIcon( Toolbox.ICON_CHECKNONEALERT30 ) );

	// Gute Gelegenheiten
	fillMenuNoCheck( ChiefJudge.GELEGENHEIT, Toolbox.getIcon( Toolbox.ICON_CHECKNONE30 ) );

	// Pruefen
	fillMenuNoCheck( ChiefJudge.PRUEFEN, Toolbox.getIcon( Toolbox.ICON_CHECKNONE30 ) );

	// Fertig
	mMenuEntries.add( this, new String( "Fertig" ), CANCEL, Toolbox.getIcon( Toolbox.ICON_OK30 ), Toolbox.getIcon( Toolbox.ICON_OK30 ) );

	// Geprueftes
	fillMenuCheck();
    }

    public void selection( SelectorListEvent evt )
    {
	MenuEntry   entry;

	entry = evt.getMenuEntry();
	switch( entry.getID() ) {

	case PART:
	    Object o = evt.getMenuEntry().getObject();
	    for( int i=0; i<mParts.size(); i++ ) {
		if( mParts.get( i )==o ) mCheckPartIndex = i;
	    }
	    InvestigateComponentPart icp = (InvestigateComponentPart)(entry.getObject());
	    mPartPanel = new InvestigateComponentPartPanel( this, icp );
	    add( mPartPanel, BorderLayout.CENTER );
	    break;

	case CANCEL:
	    mParent.onCloseChild( this );
	    break;
	}
    }

    // WIPanel Interface //
    public void onCloseChild( WIPanel child )
    {
	int   check;

	check = ((InvestigateComponentPartPanel)child).getCheckedIndex();
	if( check != -1 ) {
	    mPartChecked[mCheckPartIndex] = true;
	    fillMenu();
	    mPartList.setListData( mMenuEntries );
	}

	remove( child );
	child.close();
	mPartPanel = null;

	InputCenter.getInstance().requestFocus( mPartList );
	repaint();
    }

    public MenuVector getContextMenu()
    {
	if( mPartPanel == null )
	    return new MenuVector();
	else
	    return mPartPanel.getContextMenu();
    }

    public void dispatchContextCommand( MenuEntry e )
    {
	if( e.getSource()==this ) {
	    switch( e.getID() ) {
	    }
	} else {
	    if( mPartPanel!=null )
		mPartPanel.dispatchContextCommand( e );
	}
    }

    public void close()
    {
	mPartList.disconnect();
	if( mPartPanel!=null ) {
	    remove( mPartPanel );
	    mPartPanel.close();
	}
    }

    public void saveFocus()
    {
    }

    public void restoreFocus()
    {
	if( mPartPanel==null ) {
	    InputCenter.getInstance().requestFocus( mPartList );
	} else {
	    mPartPanel.restoreFocus();
	}
    }

}
