
/**
 * �berschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.winspect.UserInterface;

import tzi.winspect.*;
import tzi.winspect.InvestigateComponent.*;
import tzi.winspect.Investigation.Finding;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.util.*;
//import tzi.winspect.DBServices.*;
import tzi.winspect.DataService.*;
import tzi.WearableInterface.*;

public class InvestigateComponentPartPanel extends WIPanel implements SelectorListEventListener {

  private final int                             FINDING = 0;
  private final int                             CANCEL = 1;

  private WIPanel                               mParent;
  private InvestigateComponentPart              mIcp;
  private JPanel                                mMenuPanel;
  private JLabel                                mMenuHeading;
  private SelectorList                          mMenuList;
  private MenuVector                            mMenuEntries;

  private int                                   mChecked;

  private final int MENU_BILDAUFNEHMEN=1;

  public InvestigateComponentPartPanel( WIPanel parent, InvestigateComponentPart icp )
  {
    super();

    mParent = parent;
    mIcp = icp;
    mMenuEntries = new MenuVector();
    mChecked = -1;

    try {
      Vector  findings = mIcp.getPossibleFindings();
      mMenuEntries.add( this, findings, FINDING, Toolbox.getIcon( Toolbox.ICON_CHECKNONE30 ), Toolbox.getIcon( Toolbox.ICON_CHECKOK30 ) );
      mMenuEntries.add( this, new String( "Abbruch" ), CANCEL, Toolbox.getIcon( Toolbox.ICON_CANCEL30 ), Toolbox.getIcon( Toolbox.ICON_CANCEL30 ) );

      mMenuHeading = new JLabel( "Untersuchung: "+mIcp.getDetail() );
      mMenuHeading.setFont( Toolbox.getFont() );
      mMenuHeading.setForeground( Toolbox.getFontColor() );

      mMenuList = new SelectorList( mMenuEntries );
      mMenuList.addSelectorListEventListener( this );
      mMenuList.connect();
      InputCenter.getInstance().requestFocus( mMenuList );

      mMenuPanel = new JPanel();
      mMenuPanel.setBackground(Toolbox.getBackground());
      mMenuPanel.setLayout( new BorderLayout() );
      mMenuPanel.add( mMenuHeading, BorderLayout.NORTH );
      mMenuPanel.add( mMenuList, BorderLayout.CENTER );

      JPanel spacepanel = new JPanel();
      spacepanel.setPreferredSize( new Dimension( 300, 100 ) );
      spacepanel.setBackground(Toolbox.getBackground());
      mMenuPanel.add( spacepanel, BorderLayout.EAST );
      JPanel spacepanel2 = new JPanel();
      spacepanel2.setPreferredSize( new Dimension( 300, 75 ) );
      spacepanel2.setBackground(Toolbox.getBackground());
      mMenuPanel.add( spacepanel2, BorderLayout.SOUTH );
      JPanel spacepanel3 = new JPanel();
      spacepanel3.setPreferredSize( new Dimension( 300, 75 ) );
      spacepanel3.setBackground(Toolbox.getBackground());
      mMenuPanel.add( spacepanel3, BorderLayout.NORTH );

      setBorder( Toolbox.getBorder() );
      setBackground(Toolbox.getBackground());
      setLayout( new BorderLayout() );
      add( mMenuPanel, BorderLayout.CENTER );
    } catch( Exception e ) {
      e.printStackTrace();
    } catch( ObjectNotFound e ) {}
  }

  public void selection( SelectorListEvent evt )
  {
    MenuEntry   entry;

    entry = evt.getMenuEntry();
    switch( entry.getID() ) {
      case FINDING:
        mIcp.addFinding( (Finding)(entry.getObject()) );
        mChecked = evt.getIndex();
        mParent.onCloseChild( this );
        break;
      case CANCEL:
        mChecked = -1;
        mParent.onCloseChild( this );
        break;
    }

  }

  public int getCheckedIndex()
  {
    return mChecked;
  }

  // WIPanel Interface //
  public void onCloseChild( WIPanel child )
  {
  }

  public MenuVector getContextMenu()
  {
    MenuVector m=new MenuVector();
    m.add( this, new String( "Bild aufnehmen" ), MENU_BILDAUFNEHMEN, Toolbox.getIcon(Toolbox.ICON_CAMERA30), Toolbox.getIcon(Toolbox.ICON_CAMERA30) );
    return m;
  }

  public void dispatchContextCommand( MenuEntry e )
  {
    if( e.getSource()==this ) {
      switch( e.getID() ) {

        case MENU_BILDAUFNEHMEN:
            break;
      }
    } else {
    }
  }

  public void close()
  {
    mMenuList.disconnect();
  }

  public void saveFocus()
  {
  }

  public void restoreFocus()
  {
    InputCenter.getInstance().requestFocus( mMenuList );
  }

}
