/**
 * Überschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.winspect.UserInterface;

import tzi.winspect.Inspector.Inspector;
import javax.swing.*;
import java.util.Vector;
import java.awt.*;
import tzi.winspect.*;
import tzi.winspect.Debug.*;
import tzi.WearableInterface.*;

public class LoginPanel extends WIPanel implements SelectorListEventListener
{

    private SelectorList	      mList;
    private JLabel              mInfoLabel;
    private JLabel              mHeadLabel;
    private Vector              mAllInspectors;
    private WIPanel             mParent;
    private MenuVector          mMenuVector;

    private Inspector           mInspectorLoggedIn;

    public LoginPanel( WIPanel parent )
    {
	super();
    
	//Eintragen aller Inspectoren
	Main.mDebug.print(Debug.TRACE,"Frage alle Inspectoren ab");
	mAllInspectors = Main.mDBService.getAllInspectors();
	Main.mDebug.print(Debug.DEBUG,"Anzahl der Elemente in mAllInspectors:"+mAllInspectors.size());
	Main.mDebug.print(Debug.TRACE,"Trage alle Inspectoren in die SelectorList ein");

	mMenuVector = new MenuVector();
	if( mAllInspectors.size()==0 ) {
	    // Notfall: Plan B
	    /*
	      mAllInspectors.add( new Inspector( 1, "1", "hjhgj" ) );
	      mAllInspectors.add( new Inspector( 1, "2", "4564hhjhjhjhgj" ) );
	      mAllInspectors.add( new Inspector( 1, "3", "xxxhgj" ) );
	      mAllInspectors.add( new Inspector( 1, "4", "hhj657658yjhjhjhgj" ) );
	      mAllInspectors.add( new Inspector( 1, "5", "j" ) );
	      mAllInspectors.add( new Inspector( 1, "6", "xhjhgj" ) );
	      mAllInspectors.add( new Inspector( 1, "7", "hhjhjhjhgj" ) );
	      mAllInspectors.add( new Inspector( 1, "8", "hhvgvvfgj" ) );
	      mAllInspectors.add( new Inspector( 1, "9", "j" ) );
	      mAllInspectors.add( new Inspector( 1, "10", "gj" ) );
	      mAllInspectors.add( new Inspector( 1, "11", "hh" ) );
	      mAllInspectors.add( new Inspector( 1, "12", "ccchgj" ) );
	      mAllInspectors.add( new Inspector( 1, "13", "rrrrrrrrrgj" ) );
	      mAllInspectors.add( new Inspector( 1, "14", "eeeej" ) );
	      mAllInspectors.add( new Inspector( 1, "15", "e" ) );
	      mAllInspectors.add( new Inspector( 1, "16", "EEEEEEEE" ) );
	      mAllInspectors.add( new Inspector( 1, "17", "ddddvv" ) );
	      mAllInspectors.add( new Inspector( 1, "18", "rerejhgj" ) );
	      mAllInspectors.add( new Inspector( 1, "19", "hhjhjhjhgj" ) );
	      mAllInspectors.add( new Inspector( 1, "20", "r" ) );
	      mAllInspectors.add( new Inspector( 1, "21", "www" ) );
	      mAllInspectors.add( new Inspector( 1, "22", "wxxx" ) );
	      mAllInspectors.add( new Inspector( 1, "23", "zzzzzzzz" ) );
	    */
	}
	mMenuVector.add( this, mAllInspectors, 0, null, null );
	Main.mDebug.print(Debug.TRACE,"Inspektoren eingetragen");


	try {
	    mHeadLabel = new JLabel( "Willkommen bei Winspect" );
	    mHeadLabel.setFont( Toolbox.getFont() );
	    mHeadLabel.setForeground( Toolbox.getFontColor() );

	    mInfoLabel = new JLabel( "Bitte melden Sie sich an" );
	    mInfoLabel.setFont( Toolbox.getFont() );
	    mInfoLabel.setForeground( Toolbox.getFontColor() );

	    mList = new SelectorList( mMenuVector );
	    mList.addSelectorListEventListener( this );
	    Main.mDebug.print(Debug.TRACE,"mList.addSelectorListEventListener");
	    mList.connect();
	    InputCenter.getInstance().requestFocus( mList );

	    setBorder( BorderFactory.createEmptyBorder( 100, 100, 100, 100 ) );
	    setLayout( new BoxLayout( this, BoxLayout.Y_AXIS ) );
	    add( mHeadLabel );
	    add( mInfoLabel );
	    add( mList );
	}
	catch(Exception ex) {
	    ex.printStackTrace();
	}
	Main.mDebug.print(Debug.TRACE,"Login Panel erzeugt");

	mParent = parent;

    }

    public void selection(SelectorListEvent e)
    {
	mInspectorLoggedIn = (Inspector)mAllInspectors.get( e.getIndex() );
	mParent.onCloseChild( this );
    }

    public Inspector getInspectorLoggedIn()
    {
	return mInspectorLoggedIn;
    }

    // WIPanel Interface //
    public void onCloseChild( WIPanel child )
    {
    }

    public MenuVector getContextMenu()
    {
	return new MenuVector();
    }

    public void dispatchContextCommand( MenuEntry e )
    {
    }

    public void close()
    {
	mList.disconnect();
    }

    public void saveFocus()
    {
    }

    public void restoreFocus()
    {
	InputCenter.getInstance().requestFocus( mList );
    }

}

