/**
 * Ãberschrift: Winspect<p>
 * Beschreibung: <p>
 * Copyright: Copyright (c) Ansgar Schmidt<p>
 * Organisation: TZI Bremen<p>
 * @author Ansgar Schmidt
 * @version 1.0
 */
package tzi.winspect.UserInterface;

import tzi.winspect.*;
import tzi.winspect.Inspector.Inspector;
import tzi.winspect.InvestigateComponent.*;
import tzi.winspect.DBServices.*;
import tzi.UserInput.*;
//import tzi.winspect.Transfer.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;
import tzi.WearableInterface.*;

public class MainFrame extends JWindow {

  private GlobalinfoPanel           mGlobalinfoPanel;
  private MainPanel                 mMainPanel;


  public MainFrame( JFrame parent )
  {
    super( parent );
    try {
      mGlobalinfoPanel = new GlobalinfoPanel();
      mMainPanel = new MainPanel();

      getContentPane().setLayout( new BorderLayout() );
      getContentPane().add( mGlobalinfoPanel, BorderLayout.NORTH );
      getContentPane().add( Toolbox.getStatusBar(), BorderLayout.SOUTH );
      getContentPane().add( mMainPanel, BorderLayout.CENTER );

      getGlassPane().setVisible( true );
      getGlassPane().addMouseListener(new MouseAdapter(){});

    } catch( Exception e ) {
      e.printStackTrace();

    }
    addNotify();
    hideCursor();
    mMainPanel.connect();
  }

  public void finalize() {
    mMainPanel.disconnect();
  }

  private void hideCursor()
  {
    BufferedImage bi = new BufferedImage( 16, 16, BufferedImage.TYPE_INT_ARGB );
    Graphics g = bi.createGraphics();
    Cursor cursor = getToolkit().createCustomCursor( bi, new Point( 0, 0 ), "Unsichtbar" );
    setCursor( cursor );
  }

  public Dimension getPreferredSize()
  {
    return new Dimension( 640, 480 );
  }

}
