/**
 * 
 * @version $Revision: 1.4 $
 * @author Jörn Reimerdes
 */

package tzi.winspect.UserInterface;

import tzi.WearableInterface.*;
import tzi.winspect.*;
import tzi.winspect.Inspector.Inspector;
import tzi.winspect.InvestigateComponent.*;
import tzi.winspect.DataService.*;
//import tzi.winspect.DBservices.*;
import tzi.UserInput.*;
import tzi.winspect.Debug.*;

//import tzi.winspect.Transfer.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;
import tzi.WearableInterface.*;
import java.lang.String;
//import tzi.WearableInterface.BrowserWear.*;


public class MainPanel extends WIPanel implements DataObserver, WIComponent {
    
    private final int                 MENU_LOGOUT = 0;
    private final int                 MENU_EXIT = 1;
    private final int                 MENU_POWER = 2;
    private final int                 MENU_DOKU = 3;
    
    private WIPanel                   mCurrentPanel;
    private WIPanel                   mOldPanel;
    private InputReceiver             mTransponderReceiver;
    private InputReceiver             mContextReceiver;
    private InputReceiver             mPreContextReceiver;
    private InputReceiver             mTriggerReceiver;
    private InputReceiver             mPreTriggerReceiver;
    private boolean                   mTransponderActive;
    private boolean                   mContextMenuActive;
    private PowerIndicator            mPowerIndicator;
    
    
    public MainPanel() {
        super();
        
        mPowerIndicator = new PowerIndicator();
        mPowerIndicator.setBackground(Toolbox.getBackground());
        
        try {
            setLayout( new BorderLayout() );
            add( mPowerIndicator, BorderLayout.EAST );
        } catch( Exception e ) {
            e.printStackTrace();
        }
        
        mTransponderReceiver = new InputReceiver( this, InputCenter.COMPONENT_EVENT, 0, false );
        mContextReceiver = new InputReceiver( this, InputCenter.CONTEXT_EVENT, 0, false );
        mPreContextReceiver = new InputReceiver( this, InputCenter.PRECONTEXT_EVENT, 0, false );
        mTriggerReceiver = new InputReceiver( this, InputCenter.TRIGGER_EVENT, 0, false );
        mPreTriggerReceiver = new InputReceiver( this, InputCenter.PRETRIGGER_EVENT, 0, false );
        
        mCurrentPanel = null;
        mContextMenuActive = false;
        deactivateTransponder();
        openPanel( new LoginPanel( this ) );
        
        setBackground(Toolbox.getBackground());
    }
    
    private void openPanel( WIPanel panel ) {
        if( mCurrentPanel != null )
            closeCurrentPanel();
        
        mCurrentPanel = panel;
        mCurrentPanel.setBackground(Toolbox.getBackground());
        add( mCurrentPanel, BorderLayout.CENTER );
        Main.mDebug.print(Debug.TRACE,"openPanel fertig");
        
    }
    
    private void closeCurrentPanel() {
        if( mCurrentPanel != null ) {
            
            remove( mCurrentPanel );
            mCurrentPanel.close();
            mCurrentPanel = null;
            repaint();
            
        }
    }
    
    public void logIn( Inspector i ) {
        Main.mInspector = i;
        
        //    TransferClass transferClass = new TransferClass();
        //    transferClass.setActionType(transferClass.INSPECTOR_LOGIN);
        //    Main.mSocketCommunicatorClient.addTransferObject(transferClass);
        //Main.mStatusThread.setActive( true );
    }
    
    public void logOut() {
        //      TransferClass tr= new TransferClass();
        //      tr.setActionType(tr.INSPECTOR_LOGOUT);
        //      Main.mSocketCommunicatorClient.addTransferObject(tr);
        //Main.mStatusThread.setActive( false );
        Main.mInspector = null;
    }
    
    // Transponder Events //
    private void activateTransponder() {
        mTransponderActive = true;
    }
    
    private void deactivateTransponder() {
        mTransponderActive = false;
    }
    
    /** 
     * Methode wird aufgrund des implementierten DataObservers benötigt.
     * Scheint ein Event Mechanismus zu sein. Sehr unkonventionell benannt.
     */
    public void returnInvestigateComponent( InvestigateComponent ic ) {
        if( ic != null ) {
            openPanel( new InvestigateComponentPanel( this, ic ) );
            Toolbox.getStatusBar().clear();
        } else {
            Toolbox.getStatusBar().message( "Fehler: Bauteil unbekannt!", 5000 );
            repaint();
        }
        activateTransponder();
    }
    
    //  Bla //
    public Dimension getPreferredSize() {
        return new Dimension( 640, 480 );
    }
    
    // WIComponent Interface //
    public void inputEventArrives(InputCenterEvent e) {
        if( e.getID() == InputCenter.COMPONENT_EVENT ) {
            
            if( mTransponderActive ) {
                deactivateTransponder();
                closeCurrentPanel();
                Toolbox.getStatusBar().message( "Neues Bauteil gescannt. Bitte warten ...", 30000 );
                Main.mDBService.getInvestigateComponentByTransponderIDThread( e.getString(), this );
                // wenn die Daten aus der Datenbank verf�gbar sind, wird returnInvestigateComponent aufgerufen
            }
            
        } else if( e.getID() == InputCenter.CONTEXT_EVENT ) {
            
            boolean login = false;
            if( mCurrentPanel!=null ) {
                String name = mCurrentPanel.getClass().getName();
                if( name.equals( "tzi.winspect.UserInterface.LoginPanel" ) )
                    login = true;
            }
            
            if( !mContextMenuActive && !login ) {
                deactivateTransponder();
                mContextMenuActive = true;
                MenuVector m = getContextMenu();
                mOldPanel = mCurrentPanel;
                if( mCurrentPanel!=null ) {
                    mCurrentPanel.saveFocus();
                    remove( mCurrentPanel );
                    mCurrentPanel = null;
                }
                openPanel( new ContextMenu( this, m ) );
                
            }
            
        } else if( e.getID() == InputCenter.PRECONTEXT_EVENT ) {
            
            Toolbox.getStatusBar().message( "Kontextmenue wird angezeigt", 5000 );
            
        } else if( e.getID() == InputCenter.TRIGGER_EVENT ) {
            
            if( mTransponderActive ) {
                Toolbox.getStatusBar().message( "Transponder ist aktiv", 5000 );
                InputCenter.getInstance().triggerDevice( 0 );
            } else {
                Toolbox.getStatusBar().message( "Transponder ist nicht aktiv", 5000 );
            }
            
            
        } else if( e.getID() == InputCenter.PRETRIGGER_EVENT ) {
            
            if( mTransponderActive ) {
                Toolbox.getStatusBar().message( "Transponder wird aktiviert", 5000 );
            } else {
                Toolbox.getStatusBar().message( "Transponder ist zur Zeit gesperrt", 5000 );
            }
            
        }
    }
    
    public void focusGiven() {
    }
    
    public void focusTaken() {
    }
    
    public void connect() {
        InputCenter.getInstance().addInputReceiver( mTransponderReceiver );
        InputCenter.getInstance().addInputReceiver( mContextReceiver );
        InputCenter.getInstance().addInputReceiver( mPreContextReceiver );
        InputCenter.getInstance().addInputReceiver( mTriggerReceiver );
        InputCenter.getInstance().addInputReceiver( mPreTriggerReceiver );
    }
    
    public void disconnect() {
        InputCenter.getInstance().removeInputReceiver( mTransponderReceiver );
        InputCenter.getInstance().removeInputReceiver( mContextReceiver );
        InputCenter.getInstance().removeInputReceiver( mPreContextReceiver );
        InputCenter.getInstance().removeInputReceiver( mTriggerReceiver );
        InputCenter.getInstance().removeInputReceiver( mPreTriggerReceiver );
    }
    
    // WIPanel Interface //
    public void onCloseChild( WIPanel child ) {
        String childClass = child.getClass().getName();
        
        if( childClass.equals( "tzi.winspect.UserInterface.LoginPanel" ) ) {
            closeCurrentPanel();
            logIn( ((LoginPanel)child).getInspectorLoggedIn() );
            activateTransponder();
            
        } else if( childClass.equals( "tzi.winspect.UserInterface.ContextMenu" ) ) {
            MenuEntry e = ((ContextMenu)child).getSelectedContextEntry();
            closeCurrentPanel();
            if( mOldPanel!=null ) {
                openPanel( mOldPanel );
                mOldPanel.restoreFocus();
            }
            activateTransponder();
            mContextMenuActive = false;
            if( e != null ) dispatchContextCommand( e );
            
        } else {
            closeCurrentPanel();
            
        }
        
    }
    
    public MenuVector getContextMenu() {
        MenuVector m;
        
        if( mCurrentPanel!=null ) {
            m = mCurrentPanel.getContextMenu();
        } else {
            m = new MenuVector();
        }
        m.add( this, new String( "Dokumentation" ), MENU_DOKU, null, null );
        m.add( this, new String( "Batteriestand" ), MENU_POWER, Toolbox.getIcon(Toolbox.ICON_BATTERY30), Toolbox.getIcon(Toolbox.ICON_BATTERY30) );
        m.add( this, new String( "Abmelden" ), MENU_LOGOUT, Toolbox.getIcon(Toolbox.ICON_LOGOUT30), Toolbox.getIcon(Toolbox.ICON_LOGOUT30) );
        m.add( this, new String( "Winspect beenden" ), MENU_EXIT, Toolbox.getIcon(Toolbox.ICON_EXIT30), Toolbox.getIcon(Toolbox.ICON_EXIT30) );
        return m;
    }
    
    public void dispatchContextCommand( MenuEntry e ) {
        if( e.getSource()==this ) {
            switch( e.getID() ) {
                
                case MENU_DOKU:
                    Toolbox.getStatusBar().message( "Domumentationsfunktion ist nicht implementiert", 5000 );
                    //BrowserPanel bp = new BrowserPanel( this );
                    //openPanel( bp );
                    //bp.init( Documentation.getStartPage() );
                    break;
                    
                case MENU_POWER:
                    mPowerIndicator.showPower();
                    break;
                    
                case MENU_LOGOUT:
                    deactivateTransponder();
                    logOut();
                    openPanel( new LoginPanel( this ) );
                    break;
                    
                case MENU_EXIT:
                    logOut();
                    System.exit( 0 );
                    break;
            }
        } else {
            if( mCurrentPanel!=null )
                mCurrentPanel.dispatchContextCommand( e );
        }
    }
    
    public void close() {
    }
    
    public void saveFocus() {
    }
    
    public void restoreFocus() {
    }
    
}

/*
 * $Log: MainPanel.java,v $
 * Revision 1.4  2005/02/27 20:18:00  jrei
 * restructuring for xml service\nfirst tests
 *
 */
